/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm2;

import jakarta.json.JsonObject;
import ru.farmbazis.oporalocal.ILog;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.OLMBase;
import ru.farmbazis.oporalocal.olm2.synchro.Branch;
import ru.farmbazis.oporalocal.olm2.synchro.Customer;
import ru.farmbazis.oporalocal.olm2.synchro.CustomerUser;
import ru.farmbazis.oporalocal.olm2.synchro.CustomerUserInBranch;
import ru.farmbazis.oporalocal.olm2.synchro.CustomerUserInGroup;
import ru.farmbazis.oporalocal.olm2.synchro.DbUpdate;
import ru.farmbazis.oporalocal.olm2.synchro.Division;
import ru.farmbazis.oporalocal.olm2.synchro.Drug;
import ru.farmbazis.oporalocal.olm2.synchro.Fabr;
import ru.farmbazis.oporalocal.olm2.synchro.Form;
import ru.farmbazis.oporalocal.olm2.synchro.MarketingType;
import ru.farmbazis.oporalocal.olm2.synchro.Mnn;
import ru.farmbazis.oporalocal.olm2.synchro.NLS;
import ru.farmbazis.oporalocal.olm2.synchro.PluginList;
import ru.farmbazis.oporalocal.olm2.synchro.RLS;
import ru.farmbazis.oporalocal.olm2.synchro.ReestrPrice;
import ru.farmbazis.oporalocal.olm2.synchro.ReestrPriceHistory;
import ru.farmbazis.oporalocal.olm2.synchro.Registry;
import ru.farmbazis.oporalocal.olm2.synchro.SprEdIzm;
import ru.farmbazis.oporalocal.olmconfig.Config;
import ru.farmbazis.oporalocal.util.SafeJO;

public class OLM2
extends OLMBase {
    public static ISQL SQL;
    public static ILog Log;
    public static Config config;
    public static String prefix;

    public JsonObject doWork(ISQL sql, ILog log, JsonObject body) {
        SQL = sql;
        Log = log;
        SafeJO sjo = SafeJO.valueOf((JsonObject)body);
        config = new Config(sjo.getJsonObject("config"));
        String syncType = sjo.getString("sync_type", "all");
        if (syncType.equalsIgnoreCase("all")) {
            this.synchroAll();
        } else if (syncType.equalsIgnoreCase("user")) {
            this.synchroUser();
        }
        return JsonObject.EMPTY_JSON_OBJECT;
    }

    private void synchroUser() {
        new CustomerUser().synchro();
        new CustomerUserInGroup().synchro();
        new CustomerUserInBranch().synchro();
    }

    private void synchroAll() {
        new DbUpdate().synchro();
        new Branch().synchro();
        new Division().synchro();
        if (config.getDefaultBranchId() > 0L) {
            this.synchroUser();
        }
        new Customer().synchro();
        new PluginList().synchro();
        new Registry().synchro();
        new Drug().synchro();
        new Form().synchro();
        new Fabr().synchro();
        new Mnn().synchro();
        new SprEdIzm().synchro();
        new RLS().synchro();
        new NLS().synchro();
        new ReestrPrice().synchro();
        new ReestrPriceHistory().synchro();
        new MarketingType().synchro();
    }

    public static void writeLog(String msg) {
        Log.writeLog(prefix + msg);
    }

    static {
        prefix = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 ";
    }
}

