/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm2.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HexFormat;
import ru.farmbazis.oporalocal.olm2.OLM2;
import ru.farmbazis.oporalocal.olm2.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class CustomerUser
extends SynchroBase {
    public CustomerUser() {
        super("customeruser");
    }

    @Override
    protected int doWork() throws Throwable {
        JsonObject data = this.getData("olm2_customer_user_1_vdemo", this.getParam());
        SafeJO sjo = SafeJO.valueOf((JsonObject)data);
        int dataSize = sjo.getJsonArraySize("r1");
        if (dataSize > 0) {
            this.setData("olm2_customer_user_2_v1", this.transformData(sjo.getJsonArray("r1")));
        }
        return dataSize;
    }

    private JsonObject transformData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonArrayBuilder jsonArrayBuilder = array.add((JsonValue)Json.createObjectBuilder().add("customeruserid", jo.getLong("customeruserid")).add("inn", jo.getString("inn")).add("keybonusplus", jo.getString("keybonusplus")).add("username", jo.getString("username")).add("pass", this.cipherPass(jo.getString("pass"))).add("disable", jo.getBoolean("disable")).add("upd_count", jo.getLong("upd_count")).build());
        }
        return Json.createObjectBuilder().add("r1", array).build();
    }

    private String cipherPass(String pass) throws Throwable {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(pass);
        String utf8EncodedString = StandardCharsets.UTF_8.decode(buffer).toString();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] dg = md.digest(utf8EncodedString.getBytes());
        return HexFormat.of().formatHex(dg);
    }

    private JsonObjectBuilder getParam() throws Throwable {
        this.getUpdCount();
        return Json.createObjectBuilder().add("upd_count", this.updCount).add("branch_id", OLM2.config.getDefaultBranchId());
    }
}

