/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.operalocal.olm151;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import ru.atol.drivers10.fptr.Fptr;
import ru.atol.drivers10.fptr.IFptr;
import ru.farmbazis.oporalocal.ILog;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.OLMBase;

public class OLM151
extends OLMBase {
    private IFptr fptr;
    private JsonObjectBuilder outputTmp = Json.createObjectBuilder();
    private JsonObject output;
    private long sessionState;
    private String errorText = "";

    private int checkError(int result, String command) {
        if (result != 0) {
            this.errorText = this.fptr.errorDescription();
            this.outputTmp = this.outputTmp.add(command, result);
        }
        return result;
    }

    private void logResult(int result, String text, ILog iLog) {
        this.outputTmp = this.outputTmp.add("result", result);
        if (result != 0) {
            this.outputTmp = this.outputTmp.add("resultText", this.errorText);
            this.output = this.outputTmp.build();
            iLog.writeLog("OLM151: " + text + " \u041e\u0448\u0438\u0431\u043a\u0430: " + this.output.toString());
        } else {
            this.output = this.outputTmp.build();
            iLog.writeLog("OLM151: " + text + " \u0423\u0441\u043f\u0435\u0448\u043d\u043e. " + this.output.toString());
        }
    }

    private int requestState() {
        int res = -1;
        try {
            this.fptr.setParam(65587, 14);
            if (this.fptr.queryData() != 0) {
                int n = -1;
                return n;
            }
            this.sessionState = this.fptr.getParamInt(65592);
            res = 0;
            return res;
        }
        finally {
            return res;
        }
    }

    private int printText(String text) {
        return this.printText(text, 0, 0, false, false, 65539);
    }

    private int printText(String text, int align) {
        return this.printText(text, align, 0, false, false, 65539);
    }

    private int printText(String text, int align, int wrap) {
        return this.printText(text, align, wrap, false, false, 65539);
    }

    private int printText(String text, int align, int wrap, boolean dblWidth) {
        return this.printText(text, align, wrap, dblWidth, false, 65539);
    }

    private int printText(String text, int align, int wrap, boolean dblWidth, boolean dblHeight) {
        return this.printText(text, align, wrap, dblWidth, dblHeight, 65539);
    }

    private int printText(String text, int align, int wrap, boolean dblWidth, boolean dblHeight, int font) {
        this.fptr.setParam(65536, text);
        if (align != 0) {
            this.fptr.setParam(65538, align);
        }
        if (wrap != 0) {
            this.fptr.setParam(0, wrap);
        }
        if (dblWidth) {
            this.fptr.setParam(65540, dblWidth);
        }
        if (dblHeight) {
            this.fptr.setParam(65541, dblHeight);
        }
        if (font != 65539) {
            this.fptr.setParam(65539, font);
        }
        return this.checkError(this.fptr.printText(), "printText");
    }

    public static double frac(double number) {
        return number - Math.floor(number);
    }

    public static double roundTo(double value, int scale) {
        return new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    private void cancelCheck() {
        this.fptr.setParam(65587, 15);
        this.fptr.queryData();
        if (this.fptr.getParamInt(65545) != 0L) {
            this.fptr.cancelReceipt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject doWork(ISQL isql, ILog iLog, JsonObject param) throws Throwable {
        System.out.println(param.toString());
        this.output = JsonValue.EMPTY_JSON_OBJECT;
        int result = 0;
        switch (param.getJsonObject("param").getString("command")) {
            case "initDriverAndConnect": {
                if (this.fptr == null) {
                    try {
                        iLog.writeLog("OLM151: \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430...");
                        this.fptr = new Fptr();
                    }
                    catch (Throwable t) {
                        this.outputTmp = this.outputTmp.add("result", -1).add("resultText", t.getMessage());
                        return this.outputTmp.build();
                    }
                    iLog.writeLog("OLM151: \u0414\u0440\u0430\u0439\u0432\u0435\u0440 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d.");
                } else {
                    iLog.writeLog("OLM151: \u0414\u0440\u0430\u0439\u0432\u0435\u0440 \u0443\u0436\u0435 \u0431\u044b\u043b \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d \u0440\u0430\u043d\u0435\u0435.");
                }
                iLog.writeLog("OLM151: \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u041a\u041a\u0422...");
                result = this.checkError(this.fptr.open(), "open");
                this.logResult(result, "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u041a\u041a\u0422.", iLog);
                return this.output;
            }
            case "freeDriver": {
                if (this.fptr == null) break;
                this.fptr.destroy();
                this.logResult(0, "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430 \u041a\u041a\u0422.", iLog);
                return this.output;
            }
            case "openSession": {
                String comandText = "\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b.";
                result = -1;
                try {
                    this.fptr.setParam(1021, param.getJsonObject("config").getJsonObject("person").getString("shortName"));
                    if (this.checkError(this.fptr.operatorLogin(), "operatorLogin") != 0) {
                    }
                    if (this.checkError(this.fptr.openShift(), "openShift") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "sessionInfo": {
                String comandText = "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0441\u043c\u0435\u043d\u0435.";
                result = -1;
                try {
                    this.fptr.setParam(65587, 14);
                    if (this.checkError(this.fptr.queryData(), "sessionInfo") != 0) {
                    }
                    this.outputTmp.add("sessionNumber", this.fptr.getParamInt(65599));
                    this.outputTmp.add("sessionState", this.fptr.getParamInt(65592));
                    this.outputTmp.add("sessionDateEnd", this.fptr.getParamDateTime(65590).toString());
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "xReport": {
                String comandText = "\u0421\u0432\u0435\u0440\u043a\u0430 \u0438\u0442\u043e\u0433\u043e\u0432 (X-\u043e\u0442\u0447\u0435\u0442).";
                result = -1;
                try {
                    this.fptr.setParam(65546, 1);
                    if (this.checkError(this.fptr.report(), "report") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "zReport": {
                String comandText = "\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b (Z-\u043e\u0442\u0447\u0435\u0442).";
                result = -1;
                try {
                    this.fptr.setParam(65546, 0);
                    if (this.checkError(this.fptr.report(), "report") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "kkmInfo": {
                String comandText = "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u041a\u041a\u041c.";
                result = -1;
                try {
                    this.outputTmp.add("versionDrv", this.fptr.version());
                    this.fptr.setParam(65587, 0);
                    if (this.checkError(this.fptr.queryData(), "DT_STATUS") != 0) {
                    }
                    this.outputTmp.add("kkmName", this.fptr.getParamString(65603));
                    String serialNumber = this.fptr.getParamString(65559);
                    this.outputTmp.add("deviceId", serialNumber.substring(6, 13));
                    this.outputTmp.add("serialNumber", serialNumber);
                    this.outputTmp.add("fiscal", this.fptr.getParamBool(65591));
                    this.fptr.setParam(65587, 2);
                    this.fptr.setParam(65609, 1);
                    if (this.checkError(this.fptr.queryData(), "UT_CONFIGURATION") != 0) {
                    }
                    this.outputTmp.add("firmwareVersion", this.fptr.getParamString(65604));
                    this.fptr.setParam(65622, 9);
                    if (this.checkError(this.fptr.fnQueryData(), "FNDT_REG_INFO") != 0) {
                    }
                    this.outputTmp.add("taxSystem", this.fptr.getParamInt(1062));
                    switch ((int)this.fptr.getParamInt(1209)) {
                        case 100: {
                            this.outputTmp.add("versionFfd", "1");
                            break;
                        }
                        case 105: {
                            this.outputTmp.add("versionFfd", "1.05");
                            break;
                        }
                        case 110: {
                            this.outputTmp.add("versionFfd", "1.1");
                            break;
                        }
                        case 120: {
                            this.outputTmp.add("versionFfd", "1.2");
                        }
                    }
                    this.fptr.setParam(65622, 8);
                    if (this.checkError(this.fptr.fnQueryData(), "FNDT_VALIDITY") != 0) {
                    }
                    this.outputTmp.add("fiscalDateEnd", this.fptr.getParamDateTime(65590).toString());
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "sell": {
                JsonObject goods;
                String comandText = "\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0442\u043e\u0432\u0430\u0440\u0430.";
                result = -1;
                try {
                    Object text;
                    JsonObject mark;
                    JsonObject item;
                    if (this.requestState() != 0) {
                    }
                    if (this.sessionState != 1L) {
                        if (this.sessionState == 0L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                        }
                        if (this.sessionState == 2L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u0430. \u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                            return this.errorText;
                        }
                    }
                    this.cancelCheck();
                    if (this.checkError(this.fptr.cancelMarkingCodeValidation(), "cancelMarkingCodeValidation") != 0) {
                    }
                    if (this.checkError(this.fptr.clearMarkingCodeValidationResult(), "clearMarkingCodeValidationResult") != 0) {
                    }
                    JsonObject checkData = param.getJsonObject("param").getJsonObject("checkData");
                    goods = checkData.getJsonArray("goods");
                    ArrayList<String> marksFullCode = new ArrayList<String>();
                    ArrayList<Integer> marksResults = new ArrayList<Integer>();
                    for (int i = 0; i < goods.size(); ++i) {
                        item = goods.getJsonObject(i);
                        JsonArray marks = item.getJsonArray("marks");
                        if (marks.size() == 0) continue;
                        for (int ii = 0; ii < marks.size(); ++ii) {
                            int iii;
                            this.fptr.setParam(65826, 256);
                            mark = marks.getJsonObject(ii);
                            String fullCode = mark.getString("fullCode");
                            text = "";
                            if (item.getInt("tovarGroup") == 8) {
                                for (iii = 0; iii < fullCode.length() - 1; ++iii) {
                                    text = (String)text + fullCode.charAt(iii);
                                    if (!(fullCode.length() > 23 & iii == 23)) continue;
                                    text = (String)text + "\u001d";
                                }
                            }
                            if (item.getInt("tovarGroup") != 8) {
                                for (iii = 0; iii < fullCode.length() - 1; ++iii) {
                                    text = (String)text + fullCode.charAt(iii);
                                    if (!(fullCode.length() > 30 & iii == 30 | fullCode.length() > 36 & iii == 36)) continue;
                                    text = (String)text + "\u001d";
                                }
                            }
                            marksFullCode.add((String)text);
                            iLog.writeLog("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u043c\u0430\u0440\u043a\u0443: " + (String)text);
                            this.fptr.setParam(65760, (String)text);
                            if (item.getInt("ratio") > 1 & item.getInt("qnt") != item.getInt("ratio")) {
                                this.fptr.setParam(65846, 2);
                                text = String.valueOf(item.getInt("qnt")) + "/" + String.valueOf(item.getInt("ratio"));
                                this.fptr.setParam(65853, (String)text);
                                this.fptr.setParam(65633, 1.0);
                                this.fptr.setParam(65851, 0);
                            } else {
                                this.fptr.setParam(65846, 1);
                            }
                            this.fptr.setParam(65852, 0);
                            this.fptr.setParam(65845, true);
                            this.checkError(this.fptr.beginMarkingCodeValidation(), "beginMarkingCodeValidation");
                            LocalDateTime d = LocalDateTime.now();
                            while (ChronoUnit.SECONDS.between(d, LocalDateTime.now()) < 6L) {
                                this.checkError(this.fptr.getMarkingCodeValidationStatus(), "getMarkingCodeValidationStatus");
                                if (!this.fptr.getParamBool(65850)) continue;
                                iLog.writeLog("\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043c\u0430\u0440\u043a\u0438: " + String.valueOf(ChronoUnit.MILLIS.between(d, LocalDateTime.now())) + " \u043c\u0441");
                                break;
                            }
                            marksResults.add((int)this.fptr.getParamInt(65886));
                            iLog.writeLog("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043c\u0430\u0440\u043a\u0438 (2106): " + String.valueOf(this.fptr.getParamInt(65886)));
                            this.checkError(this.fptr.acceptMarkingCode(), "acceptMarkingCode");
                        }
                    }
                    this.fptr.setParam(1021, param.getJsonObject("config").getJsonObject("person").getString("shortName"));
                    if (checkData.getString("operatorInn") != "") {
                        this.fptr.setParam(1203, checkData.getString("operatorInn"));
                    }
                    if (this.checkError(this.fptr.operatorLogin(), "operatorLogin") != 0) {
                    }
                    if (checkData.getInt("taxMode") != 0) {
                        this.fptr.setParam(1055, checkData.getInt("taxMode"));
                    }
                    this.fptr.setParam(65545, 1);
                    if (checkData.getBoolean("electronically")) {
                        this.fptr.setParam(65572, true);
                    }
                    if (checkData.getString("phoneOrEmail") != "") {
                        this.fptr.setParam(1008, checkData.getString("phoneOrEmail"));
                    }
                    if (this.checkError(this.fptr.openReceipt(), "openReceipt") != 0) {
                    }
                    double sumItog = 0.0;
                    int markNumber = 0;
                    byte[] industryInfo = new byte[]{};
                    block157: for (int i = 0; i < goods.size(); ++i) {
                        item = goods.getJsonObject(i);
                        boolean isMarked = item.getJsonArray("marks").size() != 0;
                        industryInfo = new byte[]{};
                        if (isMarked && Arrays.asList(0, 7).contains(item.getInt("tovarGroup"))) {
                            this.fptr.setParam(1262, "020");
                            this.fptr.setParam(1263, "14.12.2018");
                            this.fptr.setParam(1264, "1556");
                            this.fptr.setParam(1265, "tm=mdlp&sid=" + checkData.getString("mdlpSid"));
                            this.fptr.utilFormTlv();
                            industryInfo = this.fptr.getParamByteArray(65624);
                        }
                        for (int ii = 0; ii < item.getJsonArray("marks").size(); ++ii) {
                            double posSum;
                            double posPrice;
                            double posQnt;
                            mark = item.getJsonArray("marks").getJsonObject(ii);
                            iLog.writeLog(String.valueOf(mark.getString("fullCode")));
                            if (isMarked) {
                                this.fptr.setParam(1212, 33);
                            } else {
                                this.fptr.setParam(1212, 1);
                            }
                            this.fptr.setParam(1214, 4);
                            this.fptr.setParam(2108, 0);
                            if (isMarked) {
                                this.fptr.setParam(1260, industryInfo);
                                iLog.writeLog("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043c\u0430\u0440\u043a\u0438: " + (String)marksFullCode.get(markNumber));
                                this.fptr.setParam(65826, 256);
                                this.fptr.setParam(65760, (String)marksFullCode.get(markNumber));
                                if (item.getInt("ratio") > 1 & item.getInt("qnt") != item.getInt("ratio")) {
                                    this.fptr.setParam(65846, 2);
                                    text = String.valueOf(item.getInt("qnt")) + "/" + String.valueOf(item.getInt("ratio"));
                                    this.fptr.setParam(65853, (String)text);
                                    this.fptr.setParam(65851, 0);
                                } else {
                                    this.fptr.setParam(65846, 1);
                                }
                                this.fptr.setParam(65886, ((Integer)marksResults.get(markNumber++)).intValue());
                                this.fptr.setParam(65852, 0);
                            } else if (item.getString("barcodeSiz") != "") {
                                iLog.writeLog("\u0428\u0442\u0440\u0438\u0445\u043a\u043e\u0434 \u0421\u0418\u0417: " + item.getString("barcodeSiz"));
                                this.fptr.setParam(65854, item.getString("barcodeSiz"));
                            }
                            text = "";
                            if (item.getInt("ratio") > 1) {
                                if (item.getJsonArray("marks").size() > 1) {
                                    if (mark.getInt("qnt") != item.getInt("ratio")) {
                                        text = String.valueOf(mark.getInt("qnt")) + "/" + String.valueOf(item.getInt("ratio")) + " ";
                                    }
                                } else if (item.getInt("qnt") != item.getInt("ratio")) {
                                    text = String.valueOf(item.getInt("qnt")) + "/" + String.valueOf(item.getInt("ratio")) + " ";
                                }
                            } else if (OLM151.frac(item.getJsonNumber("qnt").doubleValue()) != 0.0) {
                                text = String.format("%.3f", item.getJsonNumber("qnt").doubleValue()) + " ";
                            }
                            text = (String)text + item.getString("name");
                            iLog.writeLog((String)text);
                            this.fptr.setParam(65631, (String)text);
                            double price = item.getJsonNumber("priceWithDiscount").doubleValue();
                            if (item.getJsonArray("marks").size() > 1) {
                                if (item.getInt("ratio") > 1) {
                                    posQnt = 1.0;
                                    posSum = posPrice = OLM151.roundTo(OLM151.roundTo(price, 2) * OLM151.roundTo(mark.getJsonNumber("qnt").doubleValue(), 5), 2);
                                } else {
                                    posQnt = 1.0;
                                    posSum = posPrice = OLM151.roundTo(price, 2);
                                }
                            } else if (item.getInt("ratio") > 1) {
                                posQnt = 1.0;
                                posSum = posPrice = OLM151.roundTo(OLM151.roundTo(price, 2) * OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5), 2);
                            } else if (OLM151.frac(item.getJsonNumber("qnt").doubleValue()) == 0.0) {
                                posQnt = OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5);
                                posPrice = OLM151.roundTo(price, 2);
                                posSum = OLM151.roundTo(posQnt * posPrice, 2);
                            } else {
                                posQnt = 1.0;
                                posSum = posPrice = OLM151.roundTo(OLM151.roundTo(price, 2) * OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5), 2);
                            }
                            this.fptr.setParam(65632, posPrice);
                            this.fptr.setParam(65633, posQnt);
                            this.fptr.setParam(65634, posSum);
                            sumItog += posSum;
                            this.fptr.setParam(65571, 1);
                            this.fptr.setParam(65569, switch (item.getInt("nds")) {
                                case 0 -> 6;
                                case 20 -> 7;
                                default -> 0;
                            });
                            if (this.checkError(this.fptr.registration(), "registration") != 0) continue block157;
                        }
                    }
                    int paymentType = 0;
                    switch (checkData.getInt("typeCash")) {
                        case 0: {
                            paymentType = 0;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(sumItog));
                            break;
                        }
                        case 1: {
                            paymentType = 1;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(sumItog));
                        }
                    }
                    this.fptr.setParam(65564, paymentType);
                    this.fptr.setParam(65565, sumItog);
                    if (this.checkError(this.fptr.payment(), "payment") != 0) {
                    }
                    if (this.checkError(this.fptr.closeReceipt(), "closeReceipt") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    goods = this.output;
                    return goods;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "return": {
                String comandText = "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u043e\u0432\u0430\u0440\u0430.";
                result = -1;
                try {
                    if (this.requestState() != 0) {
                    }
                    if (this.sessionState != 1L) {
                        if (this.sessionState == 0L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                        }
                        if (this.sessionState == 2L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u0430. \u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                            return this.errorText;
                        }
                    }
                    this.cancelCheck();
                    JsonObject checkData = param.getJsonObject("param").getJsonObject("checkData");
                    JsonArray goods = checkData.getJsonArray("goods");
                    this.fptr.setParam(1021, param.getJsonObject("config").getJsonObject("person").getString("shortName"));
                    if (checkData.getString("operatorInn") != "") {
                        this.fptr.setParam(1203, checkData.getString("operatorInn"));
                    }
                    if (this.checkError(this.fptr.operatorLogin(), "operatorLogin") != 0) {
                    }
                    if (checkData.getBoolean("electronically")) {
                        this.fptr.setParam(65572, true);
                    }
                    if (checkData.getString("phoneOrEmail") != "") {
                        this.fptr.setParam(1008, checkData.getString("phoneOrEmail"));
                    }
                    if (checkData.getInt("taxMode") != 0) {
                        this.fptr.setParam(1055, checkData.getInt("taxMode"));
                    }
                    this.fptr.setParam(65545, 2);
                    if (this.checkError(this.fptr.openReceipt(), "openReceipt") != 0) {
                    }
                    double sumItog = 0.0;
                    for (int i = 0; i < goods.size(); ++i) {
                        double posSum;
                        double posPrice;
                        double posQnt;
                        JsonObject item = goods.getJsonObject(i);
                        double price = item.getJsonNumber("price").doubleValue();
                        Object text = "";
                        if (item.getInt("ratio") > 1) {
                            posQnt = 1.0;
                            posSum = posPrice = OLM151.roundTo(OLM151.roundTo(price, 2) * OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5), 2);
                            if (item.getInt("qnt") != item.getInt("ratio")) {
                                text = String.valueOf(item.getInt("qnt")) + "/" + String.valueOf(item.getInt("ratio")) + " ";
                            }
                        } else if (OLM151.frac(item.getJsonNumber("qnt").doubleValue()) == 0.0) {
                            posQnt = OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5);
                            posPrice = OLM151.roundTo(price, 2);
                            posSum = OLM151.roundTo(posQnt * posPrice, 2);
                        } else {
                            posQnt = 1.0;
                            posSum = posPrice = OLM151.roundTo(OLM151.roundTo(price, 2) * OLM151.roundTo(item.getJsonNumber("qnt").doubleValue(), 5), 2);
                            text = String.format("%.3f", item.getJsonNumber("qnt").doubleValue()) + " ";
                        }
                        text = (String)text + item.getString("name");
                        iLog.writeLog((String)text);
                        this.fptr.setParam(65631, (String)text);
                        this.fptr.setParam(65632, posPrice);
                        this.fptr.setParam(65633, posQnt);
                        this.fptr.setParam(65634, posSum);
                        sumItog += posSum;
                        this.fptr.setParam(65571, 1);
                        this.fptr.setParam(65569, switch (item.getInt("nds")) {
                            case 0 -> 6;
                            case 10 -> 2;
                            case 20 -> 7;
                            default -> 0;
                        });
                        if (this.checkError(this.fptr.registration(), "registration") != 0) break;
                    }
                    int paymentType = 0;
                    switch (checkData.getInt("typeCash")) {
                        case 0: {
                            paymentType = 0;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(sumItog));
                            break;
                        }
                        case 1: {
                            paymentType = 1;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(sumItog));
                        }
                    }
                    this.fptr.setParam(65564, paymentType);
                    this.fptr.setParam(65565, sumItog);
                    if (this.checkError(this.fptr.payment(), "payment") != 0) {
                    }
                    if (this.checkError(this.fptr.closeReceipt(), "closeReceipt") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "prepay": {
                result = -1;
                String comandText = "\u041f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0430";
                try {
                    if (this.requestState() != 0) {
                    }
                    if (this.sessionState != 1L) {
                        if (this.sessionState == 0L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                        }
                        if (this.sessionState == 2L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u0430. \u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                            return this.errorText;
                        }
                    }
                    this.cancelCheck();
                    this.fptr.setParam(1021, param.getJsonObject("config").getJsonObject("person").getString("shortName"));
                    if (param.getJsonObject("param").getString("operatorInn") != "") {
                        this.fptr.setParam(1203, param.getJsonObject("param").getString("operatorInn"));
                    }
                    if (this.checkError(this.fptr.operatorLogin(), "operatorLogin") != 0) {
                    }
                    if (param.getJsonObject("param").getInt("taxMode") != 0) {
                        this.fptr.setParam(1055, param.getJsonObject("param").getInt("taxMode"));
                    }
                    switch (param.getJsonObject("param").getString("type")) {
                        case "sell": {
                            comandText = "\u041f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0430.";
                            this.fptr.setParam(65545, 1);
                            break;
                        }
                        case "return": {
                            comandText = "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u044b.";
                            this.fptr.setParam(65545, 2);
                            break;
                        }
                        default: {
                            comandText = "\u041f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0430. \u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u043c\u0430\u043d\u0434\u044b.";
                        }
                    }
                    if (this.checkError(this.fptr.openReceipt(), "openReceipt") != 0) {
                    }
                    this.fptr.setParam(65631, param.getJsonObject("param").getString("text"));
                    this.fptr.setParam(65632, param.getJsonObject("param").getJsonNumber("summa").doubleValue());
                    this.fptr.setParam(65633, 1.0);
                    this.fptr.setParam(65571, 1);
                    switch (param.getJsonObject("param").getInt("nds")) {
                        case 0: {
                            this.fptr.setParam(65569, 6);
                            break;
                        }
                        case 120: {
                            this.fptr.setParam(65569, 8);
                        }
                    }
                    switch (param.getJsonObject("param").getInt("typeService")) {
                        case 1: {
                            this.fptr.setParam(1214, 3);
                            this.fptr.setParam(1212, 10);
                            break;
                        }
                        case 2: {
                            this.fptr.setParam(1214, 2);
                            this.fptr.setParam(1212, 10);
                            break;
                        }
                        case 3: {
                            this.fptr.setParam(1214, 1);
                            this.fptr.setParam(1212, 10);
                        }
                    }
                    this.fptr.setParam(2108, 255);
                    if (this.checkError(this.fptr.registration(), "registration") != 0) {
                    }
                    int paymentType = 0;
                    switch (param.getJsonObject("param").getInt("typeCash")) {
                        case 0: {
                            paymentType = 0;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(param.getJsonObject("param").getJsonNumber("summa").doubleValue()));
                            break;
                        }
                        case 1: {
                            paymentType = 1;
                            iLog.writeLog("\u041e\u043f\u043b\u0430\u0442\u0430 \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438: " + String.valueOf(param.getJsonObject("param").getJsonNumber("summa").doubleValue()));
                        }
                    }
                    this.fptr.setParam(65564, paymentType);
                    this.fptr.setParam(65565, param.getJsonObject("param").getJsonNumber("summa").doubleValue());
                    if (this.checkError(this.fptr.payment(), "payment") != 0) {
                    }
                    if (this.checkError(this.fptr.closeReceipt(), "closeReceipt") != 0) {
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            case "cashInOut": {
                result = -1;
                String comandText = "\u0412\u043d\u0435\u0441\u0435\u043d\u0438\u0435/\u0412\u044b\u043f\u043b\u0430\u0442\u0430.";
                try {
                    if (this.requestState() != 0) {
                    }
                    if (this.sessionState != 1L) {
                        if (this.sessionState == 0L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                        }
                        if (this.sessionState == 2L) {
                            this.errorText = "\u0421\u043c\u0435\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u0430. \u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043c\u0435\u043d\u0443.";
                            return this.errorText;
                        }
                    }
                    this.cancelCheck();
                    this.fptr.setParam(1021, param.getJsonObject("config").getJsonObject("person").getString("shortName"));
                    if (this.checkError(this.fptr.operatorLogin(), "operatorLogin") != 0) {
                    }
                    this.fptr.setParam(65613, param.getJsonObject("param").getJsonNumber("summa").doubleValue());
                    if (param.getJsonObject("param").getString("type") == "in") {
                        comandText = "\u0412\u043d\u0435\u0441\u0435\u043d\u0438\u0435 \u0432 \u043a\u0430\u0441\u0441\u0443.";
                        if (this.checkError(this.fptr.cashIncome(), "cashIncome") != 0) {
                        }
                    }
                    if (param.getJsonObject("param").getString("type") == "out") {
                        comandText = "\u0412\u044b\u043f\u043b\u0430\u0442\u0430 \u0438\u0437 \u043a\u0430\u0441\u0441\u044b.";
                        if (this.checkError(this.fptr.cashOutcome(), "cashOutcome") != 0) {
                        }
                    }
                    result = 0;
                    return result;
                }
                catch (Throwable t) {
                    this.errorText = t.getMessage();
                    this.logResult(result, comandText, iLog);
                    JsonObject jsonObject = this.output;
                    return jsonObject;
                }
                finally {
                    this.logResult(result, comandText, iLog);
                    return this.output;
                }
            }
            default: {
                this.output = this.outputTmp.add("errorText", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430: " + param.getJsonObject("param").getString("command")).add("result", -1).build();
            }
        }
        return this.output;
    }
}

