/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import ru.farmbazis.oporalocal.ILog;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.OLMBase;
import ru.farmbazis.oporalocal.olm101.SynchroThread;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olmconfig.Config;
import ru.farmbazis.oporalocal.util.SafeJO;

public class OLM101
extends OLMBase {
    public static ISQL SQL;
    public static ILog Log;
    public static Config config;
    public static String prefix;
    public static volatile boolean isHideLog;

    public void doAfterLoad() throws Throwable {
        System.out.println(prefix + "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043c\u043e\u0434\u0443\u043b\u044f");
    }

    public void doBeforeFinish() throws Throwable {
        System.out.println(prefix + "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b...");
        SynchroThread.stop();
        this.waitSynchroThreadStop();
        OLM101.reset();
    }

    private void waitSynchroThreadStop() {
        for (long pause = 0L; (SynchroThread.getStateSync() == SynchroThread.SyncState.BUSY || SynchroThread.getStateSync() == SynchroThread.SyncState.BUSY_QUICK) && pause < 600000L; pause += 1000L) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public JsonObject doWork(ISQL sql, ILog log, JsonObject body) throws Throwable {
        SafeJO so = SafeJO.valueOf((JsonObject)body).getSafeJsonObject("param");
        String command = so.getString("command");
        System.out.println(prefix + " command=" + command);
        JsonObjectBuilder jb = Json.createObjectBuilder();
        String msg = "";
        if (command.equalsIgnoreCase("state")) {
            jb.add("sync_state", SynchroThread.getStateSync().value);
        } else if (command.equalsIgnoreCase("start")) {
            if (config != null) {
                SynchroThread.stop();
                this.waitSynchroThreadStop();
                Param.setSyncType(so.getString("sync_type"));
                SynchroThread.setIsStop(false);
                SynchroThread.start();
            } else {
                msg = "\u0415\u0449\u0435 \u043d\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430";
                System.out.println(prefix + msg);
            }
        } else if (command.equalsIgnoreCase("create")) {
            if (config == null) {
                SynchroThread.start(sql, log, body);
            } else {
                msg = "\u0423\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f";
                System.out.println(prefix + msg);
            }
        } else if (command.equalsIgnoreCase("test")) {
            SynchroThread.testSync(sql, log, body);
        } else {
            msg = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430";
            System.out.println(prefix + msg);
        }
        if (!msg.isEmpty()) {
            jb.add("msg", msg);
        }
        return jb.build();
    }

    public static void writeLog(String msg) {
        if (!isHideLog) {
            Log.writeLog(prefix + msg);
        }
    }

    public static void writeError(Throwable t) {
        if (!isHideLog) {
            Log.writeError(t);
        }
    }

    private static synchronized void reset() {
        SQL = null;
        Log = null;
        config = null;
        SynchroThread.reset();
        Param.reset();
        System.out.println(prefix + "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b: OK");
    }

    static {
        prefix = "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0410\u0420\u041c ";
        isHideLog = false;
    }
}

