/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101;

import jakarta.json.JsonObject;
import java.util.concurrent.TimeUnit;
import ru.farmbazis.oporalocal.ILog;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.config.Variables;
import ru.farmbazis.oporalocal.olm101.synchro.ActualDriversAndFirmwares;
import ru.farmbazis.oporalocal.olm101.synchro.AmountInCash;
import ru.farmbazis.oporalocal.olm101.synchro.Balance;
import ru.farmbazis.oporalocal.olm101.synchro.BonusPlusTransaction;
import ru.farmbazis.oporalocal.olm101.synchro.CashDocs;
import ru.farmbazis.oporalocal.olm101.synchro.CashInOut;
import ru.farmbazis.oporalocal.olm101.synchro.CategoryHint;
import ru.farmbazis.oporalocal.olm101.synchro.DiscountForBarCode;
import ru.farmbazis.oporalocal.olm101.synchro.Doctor;
import ru.farmbazis.oporalocal.olm101.synchro.DopSale;
import ru.farmbazis.oporalocal.olm101.synchro.FixTime;
import ru.farmbazis.oporalocal.olm101.synchro.KFSParam;
import ru.farmbazis.oporalocal.olm101.synchro.KKMInfo;
import ru.farmbazis.oporalocal.olm101.synchro.License;
import ru.farmbazis.oporalocal.olm101.synchro.MDLP;
import ru.farmbazis.oporalocal.olm101.synchro.MarketingBacklight;
import ru.farmbazis.oporalocal.olm101.synchro.MatrixIco;
import ru.farmbazis.oporalocal.olm101.synchro.NameClassifier;
import ru.farmbazis.oporalocal.olm101.synchro.Permission;
import ru.farmbazis.oporalocal.olm101.synchro.PrepareSearchFragment;
import ru.farmbazis.oporalocal.olm101.synchro.PresentProducts;
import ru.farmbazis.oporalocal.olm101.synchro.PulsarCard;
import ru.farmbazis.oporalocal.olm101.synchro.RLS;
import ru.farmbazis.oporalocal.olm101.synchro.Recipe;
import ru.farmbazis.oporalocal.olm101.synchro.Registry;
import ru.farmbazis.oporalocal.olm101.synchro.Sales;
import ru.farmbazis.oporalocal.olm101.synchro.SavePlace;
import ru.farmbazis.oporalocal.olm101.synchro.ServerOptions;
import ru.farmbazis.oporalocal.olm101.synchro.Session;
import ru.farmbazis.oporalocal.olm101.synchro.SyncCount;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.olm101.synchro.TherapeuticChain;
import ru.farmbazis.oporalocal.olm101.synchro.TovarEdIzm;
import ru.farmbazis.oporalocal.olm101.synchro.TovarEdIzmCleaning;
import ru.farmbazis.oporalocal.olmconfig.Config;
import ru.farmbazis.oporalocal.util.SafeJO;

public class SynchroThread
implements Runnable {
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    private static final Object lock = new Object();
    private static final Object wait_lock = new Object();
    private static final Object quick_lock = new Object();
    private static volatile boolean isStop = false;
    private static volatile SyncState state = SyncState.UNKNOWN;
    private static volatile long pause = 5000L;
    private static volatile long startInterval = 0L;
    public static volatile boolean isBalanceOk = false;
    private final ISQL sql;
    private final ILog log;
    private final JsonObject body;
    private static int syncCount;
    public static int syncCounter;

    public SynchroThread(ISQL sql, ILog log, JsonObject body) {
        this.sql = sql;
        this.log = log;
        this.body = body;
        isStop = false;
        syncCount = 1;
        isBalanceOk = true;
        Param.setSyncType(Param.SyncType.FULL);
        Variables.reset();
    }

    public SynchroThread() {
        this.sql = null;
        this.log = null;
        this.body = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = lock;
        synchronized (object) {
            if (!isStop) {
                if (this.body != null) {
                    this.initParam();
                }
                this.synchro();
            }
            if (!isStop) {
                Object object2 = wait_lock;
                synchronized (object2) {
                    SynchroThread.wait(wait_lock, pause);
                }
            }
            if (!isStop) {
                SynchroThread.start();
            }
        }
    }

    private void synchro() {
        if (OLM101.config.getDefaultBranchId() <= 0L) {
            OLM101.writeLog("\u0424\u0438\u043b\u0438\u0430\u043b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d. \u0417\u0430\u043f\u0443\u0441\u043a \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
            SynchroThread.stop();
            return;
        }
        SynchroBase.errorCount = 0;
        if (Param.getSyncType() == Param.SyncType.QUICK) {
            this.synchroQuick();
        } else {
            OLM101.writeLog("\u043d\u0430\u0447\u0430\u043b\u043e \u0440\u0430\u0431\u043e\u0442\u044b.");
            state = SyncState.BUSY;
            if (Param.getSyncType() == Param.SyncType.FULL) {
                this.synchroFull();
            } else if (Param.getSyncType() == Param.SyncType.NORMAL) {
                this.synchroNormal();
            }
            startInterval = System.nanoTime();
            ++syncCount;
            if (SynchroBase.errorCount == 0) {
                OLM101.writeLog("\u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430; \u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u0448\u0438\u0431\u043e\u043a \u043d\u0435 \u0431\u044b\u043b\u043e.");
            } else {
                OLM101.writeLog("\u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430; \u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0431\u044b\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438. \u041a\u043e\u043b-\u0432\u043e \u043e\u0448\u0438\u0431\u043e\u043a: " + SynchroBase.errorCount);
            }
            state = SyncState.FREE;
        }
        if (Param.isUseQuickSync) {
            pause = 5000L;
            OLM101.writeLog("pause :" + pause);
        } else {
            pause = 60000L * (long)Param.syncInterval;
        }
        if (Param.isUseQuickSync && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startInterval) < (long)Param.syncInterval * 60000L) {
            Param.setSyncType(Param.SyncType.QUICK);
        } else if (syncCount < Param.getResetSyncCount()) {
            Param.setSyncType(Param.SyncType.NORMAL);
        } else {
            Param.setSyncType(Param.SyncType.FULL);
            syncCount = 1;
        }
        OLM101.writeLog("SyncType :" + Param.getSyncType());
    }

    private void synchroNormal() {
        new KFSParam().synchro();
        new ServerOptions().synchro();
        this.doSynchroQuick();
        new Session().synchro();
        new KKMInfo().synchro();
        new Registry().synchro();
        new PrepareSearchFragment().synchro();
        new TovarEdIzm().synchro();
        new TovarEdIzmCleaning().synchro();
        new FixTime().synchro();
        new CashInOut().synchro();
        new CashDocs().synchro();
        new DiscountForBarCode().synchro();
        new AmountInCash().synchro();
        if (Param.isUseDoctor) {
            new Doctor().synchro();
        }
        new CategoryHint().synchro();
        new DopSale().synchro();
        new MarketingBacklight().synchro();
        new PresentProducts().synchro();
        new Recipe().synchro();
        new PulsarCard().synchro();
        new BonusPlusTransaction().synchro();
    }

    public static void testSync(ISQL sql, ILog log, JsonObject body) {
        SynchroThread st = new SynchroThread(sql, log, body);
        try {
            st.initParam();
            new RLS().synchro();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void synchroFull() {
        this.synchroNormal();
        new SavePlace().synchro();
        new MatrixIco().synchro();
        new Permission().synchro();
        new MDLP().synchro();
        new ActualDriversAndFirmwares().synchro();
        new TherapeuticChain().synchro();
        new License().synchro();
        new NameClassifier().synchro();
        new RLS().synchro();
    }

    private void synchroQuick() {
        long start = System.nanoTime();
        OLM101.writeLog("\u0411\u044b\u0441\u0442\u0440\u0430\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430...");
        OLM101.isHideLog = true;
        state = SyncState.BUSY_QUICK;
        try {
            this.doSynchroQuick();
        }
        finally {
            state = SyncState.FREE;
            OLM101.isHideLog = false;
        }
        OLM101.writeLog("\u0411\u044b\u0441\u0442\u0440\u0430\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430. \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " \u043c\u0441");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSynchroQuick() {
        if (isBalanceOk) {
            new Sales().synchro();
            new SyncCount().synchro();
        }
        Object object = quick_lock;
        synchronized (object) {
            SynchroThread.wait(quick_lock, 2000L);
        }
        new Balance().synchro();
    }

    private void initParam() {
        SafeJO so = SafeJO.valueOf((JsonObject)this.body);
        OLM101.SQL = this.sql;
        OLM101.Log = this.log;
        OLM101.config = new Config(so.getJsonObject("config"));
        Param.init();
    }

    public static void wait(Object monitor, long millis) {
        try {
            monitor.wait(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void start() {
        Thread t = new Thread(new SynchroThread());
        t.start();
    }

    public static void start(ISQL sql, ILog log, JsonObject body) {
        Thread t = new Thread(new SynchroThread(sql, log, body));
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interruptWait() {
        Object object = wait_lock;
        synchronized (object) {
            wait_lock.notifyAll();
        }
        object = quick_lock;
        synchronized (object) {
            quick_lock.notifyAll();
        }
    }

    public static void stop() {
        isStop = true;
        SynchroThread.interruptWait();
    }

    public static void reset() {
        Variables.reset();
        syncCount = 0;
        SynchroBase.errorCount = 0;
    }

    public static SyncState getStateSync() {
        return state;
    }

    public static void setIsStop(boolean isStop) {
        SynchroThread.isStop = isStop;
    }

    public static boolean isStop() {
        return isStop;
    }

    public static enum SyncState {
        BUSY_QUICK("busy_quick"),
        FREE("free"),
        UNKNOWN("unknown"),
        BUSY("busy");

        final String value;

        private SyncState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

