/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.bean;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class CategoryHintBase {
    private long updCategoryHint;
    private long updCategoryHintNameClass;
    private long rowPartCount;
    private long rowAllCount;
    private final SynchroBase synchro;
    private final String funcName;
    private final String title;
    private final String fieldName;

    public CategoryHintBase(SynchroBase aSynchro, CategoryHintInit param) {
        this.synchro = aSynchro;
        this.updCategoryHint = param.updCategoryHint;
        this.updCategoryHintNameClass = param.updCategoryHintNameClass;
        this.title = param.title;
        this.funcName = param.funcName;
        this.fieldName = param.fieldName;
    }

    public void update() throws Throwable {
        this.rowPartCount = 1L;
        this.rowAllCount = 0L;
        while (this.rowPartCount > 0L) {
            JsonArray ja = this.getPartData();
            this.rowPartCount = ja.size();
            this.rowAllCount += this.rowPartCount;
            if (this.rowPartCount > 0L) {
                this.updatePartData(ja);
            }
            this.synchro.writeLog(String.format(this.title + ": \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updCategoryHint, this.rowPartCount, this.rowAllCount));
        }
    }

    private void updatePartData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        String regIdFieldName = this.fieldName + "_reg_id";
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            long updCountCN = jo.getLong("upd_count_ncd");
            if (updCount > this.updCategoryHint) {
                this.updCategoryHint = updCount;
            }
            if (updCountCN > this.updCategoryHintNameClass) {
                this.updCategoryHintNameClass = updCountCN;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getLong("reg_id")).add(regIdFieldName, jo.getLong(regIdFieldName)).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal(this.funcName, Json.createObjectBuilder().add("r1", array).add("upd_count", this.updCategoryHint).add("upd_count_ncd", this.updCategoryHintNameClass));
    }

    private JsonArray getPartData() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB(this.funcName, Json.createObjectBuilder().add("upd_count", this.updCategoryHint).add("upd_count_ncd", this.updCategoryHintNameClass).add("branch_id", OLM101.config.getDefaultBranchId()))).getJsonArray("r1");
    }

    public record CategoryHintInit(long updCategoryHint, long updCategoryHintNameClass, String funcName, String title, String fieldName) {
    }
}

