/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.config;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Param {
    public static int syncInterval = 5;
    private static int resetSyncCount = 12;
    public static boolean isUseQuickSync = true;
    private static SyncType syncType;
    private static String division;
    public static boolean isUseDoctor;

    public static void init() {
        isUseQuickSync = true;
        syncInterval = 5;
        Param.setResetSyncCount(12);
        if (OLM101.config.getDefaultBranchId() > 0L) {
            try {
                Param.setDivision();
            }
            catch (Throwable t) {
                OLM101.writeError(t);
            }
        }
    }

    public static SyncType getSyncType() {
        return syncType;
    }

    public static void setSyncType(SyncType syncType) {
        Param.syncType = syncType;
    }

    public static void setSyncType(String sSyncType) {
        syncType = sSyncType.equalsIgnoreCase(SyncType.FULL.value) ? SyncType.FULL : (sSyncType.equalsIgnoreCase(SyncType.NORMAL.value) ? SyncType.NORMAL : SyncType.FULL);
    }

    private static void setDivision() throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_2_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId())));
        division = response.getString("division");
        if (division.isEmpty()) {
            division = division.concat(Long.toString(OLM101.config.getDefaultBranchId()));
        }
    }

    public static String getDivision() {
        return division;
    }

    public static void reset() {
        division = "";
    }

    public static void setResetSyncCount(int resetSyncCount) {
        Param.resetSyncCount = resetSyncCount < 12 || resetSyncCount > 144 ? 12 : resetSyncCount;
    }

    public static int getResetSyncCount() {
        return resetSyncCount;
    }

    static {
        division = "";
        isUseDoctor = true;
    }

    public static enum SyncType {
        QUICK("quick"),
        FULL("full"),
        UNKNOWN("unknown"),
        NORMAL("normal");

        final String value;

        private SyncType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

