/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class AmountInCash
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        JsonArray srvId;
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_amount_in_cash_1_v1"));
        if (localData.getJsonArraySize("r1") > 0 && (srvId = this.getSrvId(this.readKKMCurrentAccumulations(localData.getJsonArray("r1")))).size() > 0) {
            this.updateKKMCurrentAccumulations(this.readSrvId(srvId));
        }
    }

    private void updateKKMCurrentAccumulations(JsonArray ja) throws Throwable {
        this.resetCounter();
        this.cnt_receive = ja.size();
        OLM101.SQL.executeLocal("olm101_amount_in_cash_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)ja));
        System.out.println("\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u043d\u0430\u044f \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u044c. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray readSrvId(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("kkm_current_accumulations_id", jo.getStringAsLong("KKMCurrentAccumulationsID")).add("kkm_current_accumulations_id_srv", jo.getStringAsLong("KKMCurrentAccumulationsID_SRV")).build());
        }
        return array.build();
    }

    private JsonArray getSrvId(JsonArray ja) throws Throwable {
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_19_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)ja)));
        return srvData.getJsonArray("r1");
    }

    private JsonArray readKKMCurrentAccumulations(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsCloseTime = jo.getTimestamp("close_time");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("KKMCurrentAccumulationsID", jo.getLong("kkm_current_accumulations_id")).add("KKMCurrentAccumulationsID_SRV", jo.getLong("kkm_current_accumulations_id_srv")).add("DeviceID", jo.getString("device_id")).add("NumberSession", jo.getInt("number_session", 0)).add("CloseTime", dateTimeFormat.format(tsCloseTime)).add("SumItog", jo.getDouble("sum_itog")).add("UserID", jo.getLong("user_id"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }
}

