/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.EnumSet;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.SynchroThread;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Balance
extends SynchroBase {
    public final String SPR_NAME = "balance";

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_balance_8_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }

    @Override
    protected void doWork() throws Throwable {
        SynchroThread.isBalanceOk = true;
        this.updCount = Param.getSyncType() == Param.SyncType.QUICK ? this.getUpdCount("balance") : 0L;
        SafeJO responseBalance = SafeJO.valueOf((JsonObject)this.execBalanceProc());
        JsonArray r1 = responseBalance.getJsonArray("r1");
        if (!SafeJO.valueOf((JsonObject)r1.getJsonObject(0)).getString("isResult").equals("1")) {
            SynchroThread.isBalanceOk = false;
            OLM101.writeLog("getBalanceOk = false");
        }
        this.updateCurrentBalance(responseBalance.getJsonArray("r2"));
        this.updateBrak(responseBalance.getJsonArray("r3"));
        this.updateDataMatrix(responseBalance.getJsonArray("r4"));
        this.updateMarkingCategory(responseBalance.getJsonArray("r5"));
        if (Param.getSyncType() != Param.SyncType.QUICK) {
            this.updateSiz(responseBalance.getJsonArray("r6"));
            this.updateTru(responseBalance.getJsonArray("r7"));
            this.updateGtinOneToMany(responseBalance.getJsonArray("r8"));
        }
        this.setIsAlive();
        this.updateAptSprTovar();
        this.updateMotivPerUnit();
    }

    private void updateMotivPerUnit() throws Throwable {
        if (Param.getSyncType() != Param.SyncType.QUICK) {
            SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_10_v1"));
            System.out.println("updateMotivPerUnit: " + (response.getBoolean("is_ok") ? "OK" : "BAD"));
        }
    }

    private void updateAptSprTovar() throws Throwable {
        this.resetCounter();
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_9_v1"));
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0442\u043e\u0432\u0430\u0440\u043e\u0432: ", EnumSet.of(SynchroBase.Counter.UPDATE, SynchroBase.Counter.INSERT));
    }

    private void setIsAlive() throws Throwable {
        OLM101.SQL.executeCDB("olm101_2_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("branchId", OLM101.config.getDefaultBranchId()));
    }

    private void updateGtinOneToMany(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.cnt_receive = ja.size();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("nakl_data_id", jo.getStringAsLong("NaklDataID")).add("gtin", jo.getString("GTIN")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_7_v1", Json.createObjectBuilder().add("data", array)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        System.out.println("updateGtinOneToMany \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert + "; \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + this.cnt_delete + ";");
    }

    private void updateTru(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getStringAsLong("regId")).add("trucode", jo.getString("code")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_6_v1", Json.createObjectBuilder().add("data", array)));
        System.out.println("updateTru row_count: " + response.getLong("row_count"));
    }

    private void updateSiz(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getStringAsLong("regId")).add("barcode_siz", jo.getString("code")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_5_v1", Json.createObjectBuilder().add("data", array)));
        System.out.println("updateSiz row_count: " + response.getLong("row_count"));
    }

    private void updateMarkingCategory(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("nakl_data_id", jo.getStringAsLong("naklDataId")).add("marking_category_id", jo.getStringAsInt("tgID")).add("gtin_by_gistt", jo.getStringAsLong("GTIN")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_4_v1", Json.createObjectBuilder().add("data", array).add("quick_sync", Param.getSyncType() == Param.SyncType.QUICK)));
        System.out.println("updateMarkingCategory row_count: " + response.getLong("row_count"));
    }

    private void updateDataMatrix(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.cnt_receive = ja.size();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("nakl_data_id", jo.getStringAsLong("NaklDataID")).add("gtin", jo.getStringAsLong("GTIN")).add("sn", jo.getString("SN")).add("u_qnt_ost", jo.getStringAsDouble("uQntOst")).add("ratio", jo.getStringAsInt("Ratio")).add("spr_ed_izm_id", jo.getStringAsLong("SprEdIzmID")).add("sscc_id", jo.getStringAsLong("SSCCID")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_3_v1", Json.createObjectBuilder().add("data", array).add("quick_sync", Param.getSyncType() == Param.SyncType.QUICK)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        System.out.println("updateDataMatrix \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert + "; \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + this.cnt_update + "; \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + this.cnt_delete + ";");
    }

    private void updateBrak(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        boolean expireSrokG = this.getKFSParam("expire_srok_g").equalsIgnoreCase("1");
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            int INCREASE_EXPIRE_SROK_G = 5;
            array.add((JsonValue)Json.createObjectBuilder().add("nakl_data_id", jo.getStringAsLong("naklDataId")).add("action_id", jo.getStringAsLong("actionId", -1L) + (long)(expireSrokG ? INCREASE_EXPIRE_SROK_G : 0)).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_2_v1", Json.createObjectBuilder().add("data", array)));
        System.out.println("updateBrak row_count: " + response.getLong("row_count"));
    }

    private void updateCurrentBalance(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.cnt_receive = ja.size();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            int nds = jo.getStringAsInt("nds");
            if (nds == 18) {
                nds = 20;
            } else if (nds != 10 && nds != 20) {
                nds = 0;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getStringAsLong("regId")).add("nakl_data_id", jo.getStringAsLong("naklDataId")).add("srok_g", jo.getString("srokG")).add("price_opt_w_nds", jo.getStringAsDouble("priceOptWNDS")).add("barcode1", jo.getString("barCode1")).add("u_qnt_ost", jo.getStringAsDouble("uQntOst")).add("u_price_rozn_w_nds", jo.getStringAsDouble("priceRoznWNDS")).add("nds", nds).add("seria", jo.getString("seria")).add("date_prix", jo.getString("createDate")).add("parent_nakl_data_id", jo.getStringAsLong("firstNaklDataId")).add("save_place_id", jo.getStringAsLong("savePlaceId")).add("price_fabr_no_nds", jo.getStringAsDouble("priceFabrNoNDS")).add("distr_id", jo.getStringAsLong("distrId")).add("is_internet", jo.getStringAsBoolean("isAptekaRu")).add("barcode2", jo.getString("barCode2")).add("number_int_order", jo.getString("numberIntOrder")).add("barcode_int_order", jo.getString("barcodeIntOrder")).add("branch_id", jo.getStringAsLong("branchID")).add("is_commission_trade", jo.getStringAsLong("CommissionTrade") > 0L).add("is_mark", jo.getStringAsBoolean("mark")).add("customer_storage_order_id", jo.getStringAsLong("CustomerStorageOrderId")).add("customer_storage", jo.getStringAsLong("CustomerStorage")).add("gtin_by_link", jo.getStringAsLong("GTINbyLink")).add("upd_count", jo.getStringAsLong("upd_count")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_balance_1_v1", Json.createObjectBuilder().add("data", array).add("quick_sync", Param.getSyncType() == Param.SyncType.QUICK)));
        this.printUpdateUQntOstLog(response.getJsonArray("update_u_qnt_ost_log"));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter();
    }

    private void printUpdateUQntOstLog(JsonArray ja) {
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            String sb = "MERGE INTO CURRENTBALANCE: nakl_data_id = " + jo.getLong("nakl_data_id") + "; u_quantity = " + jo.getDouble("u_quantity") + "; u_quantity_before_sync = " + jo.getDouble("u_quantity_before_sync") + "; u_qnt_ost = " + jo.getDouble("u_qnt_ost") + "; srv_nakl_title_r_id = " + jo.getLong("srv_nakl_title_r_id") + "; delta_q = " + jo.getDouble("delta_q") + "; u_qnt_ost_after_merge = " + jo.getDouble("u_qnt_ost_after_merge") + "; ";
            this.writeLog(sb);
        }
    }

    private JsonObject execBalanceProc() throws Throwable {
        return OLM101.SQL.executeCDB("olm101_1_v1", Json.createObjectBuilder().add("branchId", OLM101.config.getDefaultBranchId()).add("DivisionList", Param.getDivision()).add("customerId", OLM101.config.getCustomerId()).add("cityId", OLM101.config.getCityId()).add("syncCount", SynchroThread.syncCounter).add("updBalance", this.updCount).add("ComputerName", OLM101.config.getLocalHostName()));
    }
}

