/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class CashDocs
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.synchroCashDocTitle();
        this.synchroCashDocData();
        this.deleteCashDocs();
    }

    private void synchroCashDocTitle() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_cash_docs_1_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            JsonArray srvId = this.getSrvTitleId(this.readCashDocTitle(localData.getJsonArray("r1")));
            this.updateCashDocTitle(this.readSrvTitleId(srvId));
        }
    }

    private void updateCashDocTitle(JsonArray ja) throws Throwable {
        this.resetCounter();
        this.cnt_receive = ja.size();
        OLM101.SQL.executeLocal("olm101_cash_docs_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)ja));
        System.out.println("\u041a\u0430\u0441\u0441\u043e\u0432\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray readSrvTitleId(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("srv_cash_doc_title_id", jo.getStringAsLong("SrvCashDocTitleID")).add("cash_doc_title_id", jo.getStringAsLong("LocalCashDocTitleID")).build());
        }
        return array.build();
    }

    private JsonArray getSrvTitleId(JsonArray ja) throws Throwable {
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_16_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)ja)));
        return srvData.getJsonArray("r1");
    }

    private JsonArray readCashDocTitle(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsCreateDate = jo.getTimestamp("create_date");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("CashDocTypeID", jo.getLong("cash_doc_type_id")).add("glavbuhID", jo.getLong("glav_buh_id")).add("basebuh", jo.getString("base_buh")).add("CreateDate", dateTimeFormat.format(tsCreateDate)).add("Disable", jo.getBoolean("disable") ? "1" : "0").add("DeviceID", jo.getLong("device_id")).add("SessionNumber", jo.getInt("session_number", 0)).add("cashierID", jo.getLong("cashier_id")).add("ID", jo.getLong("id")).add("basecash", jo.getString("base_cash")).add("localCashDocTitleID", jo.getLong("cash_doc_title_id")).add("KKMNAME", jo.getString("kkm_name")).add("BranchId", jo.getLong("branch_id"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void synchroCashDocData() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_cash_docs_3_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.updateSrvData(this.readCashDocData(localData.getJsonArray("r1")));
        }
    }

    private void updateSrvData(JsonArray ja) throws Throwable {
        OLM101.SQL.executeCDB("olm101_17_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("r1", (JsonValue)ja));
    }

    private JsonArray readCashDocData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("CASHDOCTITLEID", jo.getLong("srv_cash_doc_title_id")).add("BASE", jo.getString("base")).add("DISABLE", jo.getBoolean("disable") ? "1" : "0").add("USERID", jo.getLong("user_id")).add("Srv_ID", jo.getLong("srv_id")).add("SUMNAKFPALLEND", jo.getDouble("sum_nak_fp_all_end")).add("SUMNAKFPALLSTART", jo.getDouble("sum_nak_fp_all_start")).add("SUMNAKFPALLENDAUTOCALC", jo.getDouble("sum_nak_fp_all_end_auto_calc"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void deleteCashDocs() throws Throwable {
        OLM101.SQL.executeLocal("olm101_cash_docs_4_v1");
    }
}

