/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class CashInOut
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_cash_in_out_1_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            JsonArray srvData = this.getSrvData(this.readCashInOut(localData.getJsonArray("r1")));
            this.updateCashInOut(this.readSrvData(srvData));
        }
    }

    private void updateCashInOut(JsonArray ja) throws Throwable {
        this.resetCounter();
        this.cnt_receive = ja.size();
        OLM101.SQL.executeLocal("olm101_cash_in_out_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)ja));
        System.out.println("\u0412\u043d\u0435\u0441\u0435\u043d\u0438\u044f/\u0412\u044b\u043f\u043b\u0430\u0442\u044b. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray readSrvData(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("srv_title_id", jo.getStringAsLong("Srv_TitleID")).add("cash_title_id", jo.getStringAsLong("Local_TitleID")).add("srv_data_id", jo.getStringAsLong("Srv_DataID")).add("cash_data_id", jo.getStringAsLong("Local_DataID")).build());
        }
        return array.build();
    }

    private JsonArray getSrvData(JsonArray ja) throws Throwable {
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_15_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)ja)));
        return srvData.getJsonArray("r1");
    }

    private JsonArray readCashInOut(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsCreateDate = jo.getTimestamp("create_date");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("Local_CashTitleID", jo.getLong("cash_title_id")).add("DeviceID", jo.getLong("device_id")).add("UserID", jo.getLong("user_id")).add("TypeOperation", jo.getString("type_operation")).add("CreateDate", dateFormatWithMs.format(tsCreateDate)).add("SessionNumber", jo.getLong("session_number")).add("Local_CashDataID", jo.getLong("cash_data_id")).add("OtherSprID", jo.getLong("other_spr_id")).add("CashSum", CashInOut.getDoubleStr(jo.getDouble("cash_sum"))).add("Comment", jo.getString("comment")).add("CashSumUser", jo.getString("cash_sum_user"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }
}

