/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import java.util.EnumSet;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Certificate
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_certificate_1_v1"));
        this.cnt_send = localData.getJsonArraySize("r1");
        if (this.cnt_send > 0) {
            this.saveOnSrv(localData.getJsonArray("r1"));
            this.deleteSavedRow();
            this.printCounter("", EnumSet.of(SynchroBase.Counter.SEND));
        }
    }

    private void deleteSavedRow() throws Throwable {
        OLM101.SQL.executeLocal("olm101_certificate_2_v1");
    }

    private boolean saveOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            Timestamp tsDateUpdate = jo.getTimestamp("date_update");
            jBuild.add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("doc_type", jo.getInt("doc_type", 0)).add("barcode", jo.getString("barcode")).add("is_send", jo.getBoolean("is_send") ? "1" : "0").add("guid", jo.getString("guid")).add("date_update", jo.getString(dateTimeFormat.format(tsDateUpdate)));
            array.add((JsonValue)jBuild.build());
        }
        SafeJO result = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_33_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)array.build())));
        if (result.getJsonArraySize("r1") > 0) {
            return result.getJsonArray("r1").getJsonObject(0).getInt("isOK") == 1;
        }
        return false;
    }
}

