/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class CodeLPU
extends SynchroBase {
    private long updCodeLPU;

    @Override
    protected void doWork() throws Throwable {
        if (OLM101.config.getCustomerId() != 14400L && OLM101.config.getCustomerId() != 263L) {
            return;
        }
        this.updCodeLPU = this.getUpdCount("CODELPUFORNLS");
        JsonArray ja = this.getData();
        if (ja.size() > 0) {
            this.updateData(ja);
        }
    }

    private void updateData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double clfnId = jo.getDouble("code_lpu_for_nls_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updCodeLPU) {
                this.updCodeLPU = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("code_lpu_for_nls_id", Double.valueOf(clfnId).longValue()).add("rbd_code_lpu_for_nls_id", clfnId).add("customer_id", jo.getLong("customer_id")).add("disable", jo.getBoolean("disable")).add("uid", jo.getString("uid")).add("city", jo.getString("city")).add("comment", jo.getString("comment")).add("farm_license_valid", jo.getString("farm_license_valid")).build());
        }
        OLM101.SQL.executeLocal("olm101_code_lpu_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updCodeLPU));
    }

    private JsonArray getData() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_code_lpu_1_v1", Json.createObjectBuilder().add("upd_count", this.updCodeLPU).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }
}

