/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class DataForPrintingForms
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.insertDataForPrintingForms(this.getDataForPrintingForms());
    }

    private void insertDataForPrintingForms(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("size 0");
            return;
        }
        String UseAuthorizedCashier = "0";
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            UseAuthorizedCashier = jo.getBoolean("use_authorized_cashier") ? "1" : "0";
            array.add((JsonValue)Json.createObjectBuilder().add("prefix", jo.getString("prefix")).add("cashier", jo.getString("cashier_user_name")).add("base_cash", jo.getString("base_cash")).add("glav_buh_id", jo.getLong("glav_buh_id")).add("glav_buh", jo.getString("glav_buh_user_name")).add("base_buh", jo.getString("base")).build());
        }
        OLM101.SQL.executeLocal("olm101_data_print_form_1_v1", Json.createObjectBuilder().add("r1", array));
        this.setKFSParam("UseAuthorizedCashier", UseAuthorizedCashier);
    }

    private JsonArray getDataForPrintingForms() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_data_print_form_1_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()))).getJsonArray("r1");
    }

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_data_print_form_2_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }
}

