/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Discount
extends SynchroBase {
    long updCustomerDiscount = 0L;
    long updDiscountInBranch = 0L;
    long updTypeDiscountData = 0L;
    long updTypeDiscountTitle = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_discount_2_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        JsonArray ja = this.getData();
        if (ja.size() > 0) {
            this.updateData(ja);
        }
    }

    private void updateData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updCustomerDiscount = jo.getStringAsLong("updCustomerDiscount");
            long _updDiscountInBranch = jo.getStringAsLong("updDiscountInBranch");
            long _updTypeDiscountData = jo.getStringAsLong("updTypeDiscountData");
            long _updTypeDiscountTitle = jo.getStringAsLong("updTypeDiscountTitle");
            if (_updCustomerDiscount > this.updCustomerDiscount) {
                this.updCustomerDiscount = _updCustomerDiscount;
            }
            if (_updDiscountInBranch > this.updDiscountInBranch) {
                this.updDiscountInBranch = _updDiscountInBranch;
            }
            if (_updTypeDiscountData > this.updTypeDiscountData) {
                this.updTypeDiscountData = _updTypeDiscountData;
            }
            if (_updTypeDiscountTitle > this.updTypeDiscountTitle) {
                this.updTypeDiscountTitle = _updTypeDiscountTitle;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("customer_discount_id", jo.getStringAsLong("customerDiscountId")).add("name", jo.getString("discountName")).add("discount", jo.getStringAsDouble("discount")).add("discount_j", jo.getStringAsDouble("discountJ")).add("customer_id", jo.getStringAsLong("customerId")).add("hand_discount", jo.getString("handDiscount")).add("sum_all_check", jo.getStringAsDouble("sumAllCheck")).add("sum_one_string", jo.getStringAsDouble("sumOneString")).add("sum_discount", jo.getStringAsDouble("sumDiscount")).add("disable", jo.getStringAsBoolean("disable")).add("comment", jo.getString("comment")).add("color", jo.getStringAsInt("color")).add("bonus_discount", jo.getStringAsBoolean("bonusDiscount")).add("lim_cnt_discount", jo.getStringAsInt("limCntDiscount")).add("is_reset", jo.getStringAsBoolean("isReset")).add("type_discount_title_id", jo.getStringAsLong("typeDiscountTitleId")).add("discount_for_bonus", jo.getStringAsDouble("discountForBonus")).add("discount_for_bonus_j", jo.getStringAsDouble("discountForBonusJ")).add("percent_accum_j", jo.getStringAsDouble("percentAccumJ")).add("is_use_range_cards", jo.getStringAsBoolean("isUseRangeCards")).add("is_not_apply_prepacking", jo.getStringAsBoolean("isNotApplyPrepacking")).add("enable_write_off_in_card_create_day", jo.getStringAsBoolean("EnableWriteOffInCardCreateDay")).add("fixed_margin_percent", jo.getStringAsDouble("fixedMarginPercent")).add("lim_cnt_discount_m", jo.getStringAsInt("limCntDiscountM")).add("count_qnt", jo.getStringAsBoolean("countQntForSeveralTovCheck")).build());
        }
        OLM101.SQL.executeLocal("olm101_discount_1_v1", Json.createObjectBuilder().add("r1", array).add("updCustomerDiscount", this.updCustomerDiscount).add("updDiscountInBranch", this.updDiscountInBranch).add("updTypeDiscountData", this.updTypeDiscountData).add("updTypeDiscountTitle", this.updTypeDiscountTitle));
    }

    private JsonArray getData() throws Throwable {
        this.updCustomerDiscount = this.getUpdCount("CustomerDiscount");
        this.updDiscountInBranch = this.getUpdCount("DiscountInBranch");
        this.updTypeDiscountData = this.getUpdCount("TypeDiscountData");
        this.updTypeDiscountTitle = this.getUpdCount("TypeDiscountTitle");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_23_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("customer_id", OLM101.config.getCustomerId()).add("updCustomerDiscount", this.updCustomerDiscount).add("updDiscountInBranch", this.updDiscountInBranch).add("updTypeDiscountData", this.updTypeDiscountData).add("updTypeDiscountTitle", this.updTypeDiscountTitle))).getJsonArray("r1");
    }
}

