/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class DiscountCondition
extends SynchroBase {
    long updDiscountConditionTitle = 0L;
    long updDiscountConditionData = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_discount_3_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        JsonArray r2;
        SafeJO jo = this.getData();
        JsonArray r1 = jo.getJsonArray("r1");
        if (r1.size() > 0) {
            this.updateTitle(r1);
        }
        if ((r2 = jo.getJsonArray("r2")).size() > 0) {
            this.updateData(r2);
        }
    }

    private void updateTitle(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updDiscountConditionTitle = jo.getStringAsLong("updCount");
            if (_updDiscountConditionTitle > this.updDiscountConditionTitle) {
                this.updDiscountConditionTitle = _updDiscountConditionTitle;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("title_id", jo.getStringAsLong("DiscountConditionTitleID")).add("discount_id", jo.getStringAsLong("CustomerDiscountID")).add("disable", jo.getStringAsBoolean("Disable")).add("discount", jo.getStringAsDouble("discount")).add("discount_j", jo.getStringAsDouble("discountJ")).build());
        }
        OLM101.SQL.executeLocal("olm101_discount_4_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDiscountConditionTitle));
    }

    private void updateData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updDiscountConditionData = jo.getLong("updCount");
            if (_updDiscountConditionData > this.updDiscountConditionData) {
                this.updDiscountConditionData = _updDiscountConditionData;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("title_id", jo.getStringAsLong("DiscountConditionTitleID")).add("data_id", jo.getStringAsLong("DiscountConditionDataID")).add("disable", jo.getStringAsBoolean("Disable")).add("condition_type_id", jo.getStringAsLong("ConditionTypeID")).add("operand1", jo.getString("Operand1")).add("operand2", jo.getString("Operand2")).build());
        }
        OLM101.SQL.executeLocal("olm101_discount_5_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDiscountConditionData));
    }

    private SafeJO getData() throws Throwable {
        this.updDiscountConditionTitle = this.getUpdCount("DiscountConditionTitle");
        this.updDiscountConditionData = this.getUpdCount("DiscountConditionData");
        SafeJO jo = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_24_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("updTitle", this.updDiscountConditionTitle).add("updData", this.updDiscountConditionData)));
        SafeJO.saveToFile((String)"c:\\olm101_24_v1.json", (JsonObject)jo.getInstance());
        return jo;
    }
}

