/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class DiscountForDistr
extends SynchroBase {
    long updDiscountForDistr = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_discount_6_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        long rowPartCount = 1L;
        long rowAllCount = 0L;
        while (rowPartCount > 0L) {
            JsonArray ja = this.getPartData();
            rowPartCount = ja.size();
            rowAllCount += rowPartCount;
            if (rowPartCount > 0L) {
                this.updatePartData(ja);
            }
            this.writeLog(String.format(": \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updDiscountForDistr, rowPartCount, rowAllCount));
        }
    }

    private void updatePartData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updDiscountForDistr = jo.getStringAsLong("updCount");
            if (_updDiscountForDistr > this.updDiscountForDistr) {
                this.updDiscountForDistr = _updDiscountForDistr;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("condition_data_id", jo.getStringAsLong("DiscountConditionDataID")).add("distr_id", jo.getStringAsLong("DistrID")).add("disable", jo.getStringAsBoolean("Disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_discount_7_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDiscountForDistr));
    }

    private JsonArray getPartData() throws Throwable {
        this.updDiscountForDistr = this.getUpdCount("discountfordistr");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_25_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("upd_count", this.updDiscountForDistr))).getJsonArray("r1");
    }
}

