/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class DiscountForGroup
extends SynchroBase {
    long updDiscountInBranch = 0L;
    long updDiscountForGroup = 0L;
    long updDiscountWeekDay = 0L;
    long updDiscountNDS = 0L;
    long updCustomerDiscount = 0L;
    long updDiscountForRegID = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_discount_8_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        JsonArray r3;
        JsonArray r2;
        SafeJO jo = this.getData();
        JsonArray r1 = jo.getJsonArray("r1");
        if (r1.size() > 0) {
            this.updateDiscountForGroup(r1);
        }
        if ((r2 = jo.getJsonArray("r2")).size() > 0) {
            this.updateDiscountWeekDay(r2);
        }
        if ((r3 = jo.getJsonArray("r3")).size() > 0) {
            this.updateDiscountNDS(r3);
        }
        JsonArray r4 = this.getDataForReg();
        if (r2.size() > 0) {
            this.updateDiscountForRegID(r4);
        }
    }

    private void updateDiscountForGroup(JsonArray ja) throws Throwable {
    }

    private void updateDiscountWeekDay(JsonArray ja) throws Throwable {
    }

    private void updateDiscountNDS(JsonArray ja) throws Throwable {
    }

    private void updateDiscountForRegID(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updDiscountForRegID = jo.getStringAsLong("updCount");
            if (_updDiscountForRegID > this.updDiscountForRegID) {
                this.updDiscountForRegID = _updDiscountForRegID;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("customer_discount_id", jo.getStringAsLong("CustomerDiscountID")).add("reg_id", jo.getStringAsLong("RegID")).add("yes_no_apply", jo.getStringAsBoolean("YesNoApply")).add("disable", jo.getStringAsBoolean("Disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_discount_12_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDiscountForRegID));
    }

    private SafeJO getData() throws Throwable {
        this.updDiscountInBranch = this.getUpdCount("DiscountForGroup_DiscountInBranch");
        this.updDiscountForGroup = this.getUpdCount("DiscountForGroup");
        this.updDiscountWeekDay = this.getUpdCount("DiscountWeekDay");
        this.updDiscountNDS = this.getUpdCount("DiscountNDS");
        this.updCustomerDiscount = this.getUpdCount("DiscountForGroup_CustomerDiscount");
        SafeJO jo = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_27_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("updDiscountInBranch", this.updDiscountInBranch).add("updDiscountForGroup", this.updDiscountForGroup).add("updDiscountWeekDay", this.updDiscountWeekDay).add("updDiscountNDS", this.updDiscountNDS).add("updCustomerDiscount", this.updCustomerDiscount)));
        SafeJO.saveToFile((String)"c:\\olm101_27_v1.json", (JsonObject)jo.getInstance());
        return jo;
    }

    private JsonArray getDataForReg() throws Throwable {
        this.updDiscountForRegID = this.getUpdCount("");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_28_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("upd_count", this.updDiscountForRegID))).getJsonArray("r1");
    }
}

