/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Doctor
extends SynchroBase {
    private long updDoctor = 0L;

    @Override
    protected void doWork() throws Throwable {
        this.updateDoctor(this.getDoctorlist());
    }

    private JsonArray getDoctorlist() throws Throwable {
        this.updDoctor = this.getUpdCount("doctor_list");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_doctor_1_v1", Json.createObjectBuilder().add("upd_count", this.updDoctor).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }

    private void updateDoctor(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u0440\u0430\u0447\u0435\u0439. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double doctorListId = jo.getDouble("doctor_list_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updDoctor) {
                this.updDoctor = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_doctor_list_id", doctorListId).add("fio", jo.getString("fio")).add("doctor_list_id", Double.valueOf(doctorListId).longValue()).add("bar_code", jo.getString("bar_code")).add("disable", jo.getBoolean("disable")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_doctor_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDoctor)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter();
    }

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_doctor_2_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }
}

