/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class DopSale
extends SynchroBase {
    private long updDopSale;
    private long rowPartCount;
    private long rowAllCount;

    @Override
    protected void doWork() throws Throwable {
        this.updDopSale = this.getUpdCount("DopSaleForm");
        this.rowPartCount = 1L;
        this.rowAllCount = 0L;
        while (this.rowPartCount > 0L) {
            JsonArray ja = this.getPartData();
            this.rowPartCount = ja.size();
            this.rowAllCount += this.rowPartCount;
            if (this.rowPartCount > 0L) {
                this.updatePartData(ja);
            }
            this.writeLog(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updDopSale, this.rowPartCount, this.rowAllCount));
        }
    }

    private void updatePartData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updDopSale) {
                this.updDopSale = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("main_drug_id", jo.getLong("main_drug_id")).add("slave_drug_id", jo.getLong("slave_drug_id")).add("main_form_id", jo.getLong("main_form_id")).add("slave_form_id", jo.getLong("slave_form_id")).add("slave_drug_cnt", jo.getLong("slave_cnt")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_dop_sale_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updDopSale));
    }

    private JsonArray getPartData() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_dop_sale_1_v1", Json.createObjectBuilder().add("upd_count", this.updDopSale).add("branch_id", OLM101.config.getDefaultBranchId()))).getJsonArray("r1");
    }
}

