/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class FixTime
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_fix_time_1_v1"));
        if (localData.getJsonArraySize("r1") > 0 && this.updateFixTime(this.readFixTime(localData.getJsonArray("r1")))) {
            this.deleteFixTime();
        }
    }

    private boolean updateFixTime(JsonArray localData) {
        try {
            OLM101.SQL.executeRDB("olm101_fix_time_1_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("fix_time", (JsonValue)localData));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private JsonArray readFixTime(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsTime = jo.getTimestamp("fix_time");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("branch_id", jo.getLong("branch_id")).add("docunent_title_r_id", jo.getLong("nakl_title_r_id")).add("customer_user_id", jo.getLong("user_id")).add("device_id", jo.getString("device_id")).add("type", String.valueOf(jo.getInt("fix_type", 0))).add("date", FixTime.formatDateTimeUTC(tsTime));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void deleteFixTime() throws Throwable {
        OLM101.SQL.executeLocal("olm101_fix_time_2_v1");
    }
}

