/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.stream.Collectors;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Inventory
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        String inventoryTitleIds = this.getInventoryTitleIds();
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_34_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("inventory_title_id", inventoryTitleIds)));
        this.updateInventory(srvData);
    }

    private void updateInventory(SafeJO srvData) throws Throwable {
        JsonArray r1 = srvData.getJsonArray("r1");
        String joinedIds = r1.stream().map(jo -> ((JsonObject)jo).getString("InventoryTitleID")).collect(Collectors.joining(","));
        JsonArray r2 = srvData.getJsonArray("r2");
        JsonArrayBuilder array2 = Json.createArrayBuilder();
        for (int i = 0; i < r2.size(); ++i) {
            SafeJO jo2 = SafeJO.valueOf((JsonObject)r2.getJsonObject(i));
            array2.add((JsonValue)Json.createObjectBuilder().add("branch_id", jo2.getStringAsLong("BranchID")).add("inventory_title_id", jo2.getStringAsLong("InventoryTitleID")).add("is_partial_inv", jo2.getStringAsBoolean("isPartialInv")).build());
        }
        OLM101.SQL.executeLocal("olm101_inventory_2_v1", Json.createObjectBuilder().add("for_del", joinedIds).add("for_ins", (JsonValue)array2.build()));
    }

    private String getInventoryTitleIds() throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_inventory_1_v1"));
        return response.getString("ids");
    }
}

