/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.HashMap;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.config.Variables;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class KFSParam
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        String parentNode = this.getParentNode();
        HashMap<String, String> KFSParams = new HashMap<String, String>();
        this.getBranchData(KFSParams);
        this.getParentData(parentNode, KFSParams);
        JsonArray jaDivision = this.getDivisionData(Param.getDivision());
        this.saveDivision(jaDivision);
        this.setKFSParam(KFSParams);
    }

    private void saveDivision(JsonArray ja) throws Throwable {
        OLM101.SQL.executeLocal("olm101_kfsparam_2_v1", Json.createObjectBuilder().add("data", (JsonValue)ja));
    }

    private JsonArray getDivisionData(String division) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_kfsparam_5_v1", Json.createObjectBuilder().add("branch_id", division)));
        JsonArray ja = response.getJsonArray("r1");
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("param", "BRANCHENVD").add("branch_id", jo.getLong("branch_id")).add("value", jo.getBoolean("type_usn")).build());
        }
        return array.build();
    }

    private String getParentNode() throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("get_parent_customer_node", Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId())));
        String node = response.getString("db_node_ro");
        OLM101.writeLog("parent_node: " + node);
        return node;
    }

    private void getBranchData(HashMap<String, String> KFSParams) throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_kfsparam_3_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId())));
        JsonArray ja = response.getJsonArray("r1");
        if (ja.size() > 0) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(0));
            KFSParams.put("DiscountPriceOpt", jo.getBoolean("discount_price_opt") ? "1" : "0");
            KFSParams.put("BRANCHENVD", jo.getBoolean("is_envd") ? "1" : "0");
            KFSParams.put("PPKU_COD", "" + jo.getInt("ppku_code"));
            Variables.MTO_NormalDiscount = jo.getBoolean("mto_normal_discount");
            KFSParams.put("MTO_NormalDiscount", Variables.MTO_NormalDiscount ? "1" : "0");
            Variables.MTO_AutoDiscount = jo.getBoolean("mto_auto_discount");
            KFSParams.put("MTO_AutoDiscount", Variables.MTO_AutoDiscount ? "1" : "0");
            Variables.MTO_DiscountCards = jo.getBoolean("mto_discount_cards");
            KFSParams.put("MTO_DiscountCards", Variables.MTO_DiscountCards ? "1" : "0");
            Variables.MTO_BonusCards = jo.getBoolean("mto_bonus_cards");
            KFSParams.put("MTO_BonusCards", Variables.MTO_BonusCards ? "1" : "0");
            KFSParams.put("MTO_BanApplyBonus", jo.getBoolean("ban_apply_bonus") ? "1" : "0");
            KFSParams.put("clientIdASNA", jo.getString("client_id"));
            KFSParams.put("olekstraServer", jo.getString("olekstra_server"));
            KFSParams.put("olekstraDrugstoreId", jo.getString("olekstra_drugstore_id"));
            KFSParams.put("MTO_PREPAY_COPYCOUNT", "" + jo.getInt("prepay_copy_count"));
            KFSParams.put("expire_srok_g", jo.getBoolean("expire_srok_g") ? "1" : "0");
            KFSParams.put("quick_sync", jo.getBoolean("quick_sync") ? "1" : "0");
            KFSParams.put("made_to_order", jo.getBoolean("made_to_order") ? "1" : "0");
            KFSParams.put("showBlueRlsIcon", jo.getBoolean("is_save_recipe") ? "1" : "0");
            KFSParams.put("showMotivBonusArm", jo.getBoolean("show_motiv_bonus_arm") ? "1" : "0");
            KFSParams.put("work_with_electronic_recipe", jo.getBoolean("work_with_electronic_recipe") ? "1" : "0");
            KFSParams.put("E1RxClientId", jo.getString("E1RxClientId"));
            KFSParams.put("E1RxClientSecret", jo.getString("E1RxClientSecret"));
        }
    }

    private void getParentData(String parentNode, HashMap<String, String> KFSParams) throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB(parentNode, "olm101_kfsparam_4_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId())));
        JsonArray ja = response.getJsonArray("r1");
        if (ja.size() > 0) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(0));
            KFSParams.put("workAptekaLoyalty", jo.getBoolean("work_Apteka_Loyalty") ? "1" : "0");
            KFSParams.put("useBuyerINN", jo.getBoolean("use_buyer_inn") ? "1" : "0");
            KFSParams.put("RequestNotePendingCheck", jo.getBoolean("request_note_pending_check") ? "1" : "0");
            KFSParams.put("MarkScanForDelete", jo.getBoolean("mark_scan_for_delete") ? "1" : "0");
            KFSParams.put("subsidized_medicines", jo.getBoolean("subsidized_medicines") ? "1" : "0");
            KFSParams.put("do_not_check_mark", jo.getBoolean("do_not_check_mark") ? "1" : "0");
            KFSParams.put("uds", jo.getBoolean("uds") ? "1" : "0");
            KFSParams.put("allow_skip_recipe", jo.getBoolean("allow_skip_recipe") ? "1" : "0");
        }
    }
}

