/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class KKMInfo
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        JsonArray ja = this.getKKMInfo();
        this.uploadKKMInfo(ja);
    }

    private void uploadKKMInfo(JsonArray ja) throws Throwable {
        OLM101.SQL.executeCDB("olm101_5_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("branchId", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)ja));
    }

    private JsonArray getKKMInfo() throws Throwable {
        JsonArray ja = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_kkm_info_1_v1")).getJsonArray("r1");
        JsonArrayBuilder array = Json.createArrayBuilder();
        if (ja.size() == 0) {
            return array.build();
        }
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO sjo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp ts = sjo.getTimestamp("last_use_date");
            array.add((JsonValue)Json.createObjectBuilder().add("device_id", sjo.getStringAsLong("device_id", -1L) == -1L ? "" : sjo.getString("device_id")).add("kkm_name", sjo.getString("kkm_name")).add("version_drv", sjo.getString("version_drv")).add("kfs_drv", sjo.getInt("kfs_drv")).add("is_fiscal", sjo.getBoolean("is_fiscal") ? "1" : "0").add("is_session_number", sjo.getBoolean("is_session_number") ? "1" : "0").add("full_device_id", sjo.getString("full_device_id")).add("last_use_date", ts.getTime() == 0L ? "" : dateFormat.format(ts)).add("firmware_version", sjo.getString("firmware_version")).add("version_ffd", sjo.getString("version_ffd")).add("fiscal_date_end", sjo.getString("fiscal_date_end")).add("tax_system", sjo.getInt("tax_system")).build());
        }
        return array.build();
    }
}

