/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import java.util.EnumSet;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class LogArmOptions
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_log_arm_1_v1"));
        this.cnt_send = localData.getJsonArraySize("r1");
        if (this.cnt_send > 0) {
            this.saveOnSrv(localData.getJsonArray("r1"));
            this.deleteSavedRow();
            this.printCounter("", EnumSet.of(SynchroBase.Counter.SEND));
        }
    }

    private void deleteSavedRow() throws Throwable {
        OLM101.SQL.executeLocal("olm101_log_arm_2_v1");
    }

    private void saveOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            Timestamp tsDateUpdate = jo.getTimestamp("date_update");
            jBuild.add("option_group", jo.getString("option_group")).add("option_name", jo.getString("option_name")).add("old_value", jo.getString("old_value")).add("new_value", jo.getString("new_value")).add("user_id", jo.getLong("user_id")).add("comp_name", jo.getString("comp_name")).add("date_update", jo.getString(dateTimeFormat.format(tsDateUpdate)));
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_32_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)array.build()));
    }
}

