/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class MarketingBacklight
extends SynchroBase {
    long updMarketingType = 0L;
    long updMarketingBacklight = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_marketing_3_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        this.updateMarketingType();
        this.updateMarketingBacklight();
    }

    private void updateMarketingType() throws Throwable {
        this.updMarketingType = this.getUpdCount("MarketingType");
        long rowPartCount = 1L;
        while (rowPartCount > 0L) {
            JsonArray ja = this.getPartDataType();
            rowPartCount = ja.size();
            if (rowPartCount <= 0L) continue;
            this.updatePartDataType(ja);
        }
    }

    private void updatePartDataType(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updMarketingType) {
                this.updMarketingType = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("marketing_type_id", jo.getLong("marketing_type_id")).add("marketing_type", jo.getString("marketing_type")).add("ico_name", jo.getString("ico_name")).add("hint_prefix", jo.getString("hint_prefix")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_marketing_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updMarketingType));
    }

    private JsonArray getPartDataType() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_marketing_1_v1", Json.createObjectBuilder().add("upd_count", this.updMarketingType))).getJsonArray("r1");
    }

    private void updateMarketingBacklight() throws Throwable {
        this.updMarketingBacklight = this.getUpdCount("MarketingBacklight");
        long rowPartCount = 1L;
        long rowAllCount = 0L;
        while (rowPartCount > 0L) {
            JsonArray ja = this.getPartDataBacklight();
            rowPartCount = ja.size();
            rowAllCount += rowPartCount;
            if (rowPartCount > 0L) {
                this.updatePartDataBacklight(ja);
            }
            this.writeLog(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updMarketingBacklight, rowPartCount, rowAllCount));
        }
    }

    private JsonArray getPartDataBacklight() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_marketing_2_v1", Json.createObjectBuilder().add("upd_count", this.updMarketingBacklight).add("branch_id", Param.getDivision()))).getJsonArray("r1");
    }

    private void updatePartDataBacklight(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updMarketingBacklight) {
                this.updMarketingBacklight = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("branch_id", jo.getLong("branch_id")).add("reg_id", jo.getLong("reg_id")).add("marketing_type_id", jo.getLong("marketing_type_id")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_marketing_2_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updMarketingBacklight));
    }
}

