/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class MatrixIco
extends SynchroBase {
    private long updMMMatrixInBranch = 0L;
    private long updMinMaxMatrixTitle = 0L;
    private long updMinMaxMatrixData = 0L;
    private long updMinMaxMatrixMotivPlan = 0L;

    @Override
    protected void doWork() throws Throwable {
        String division = Param.getDivision();
        JsonObject jo = this.getRegIco(division);
        this.updateRegIco(SafeJO.valueOf((JsonObject)jo).getJsonArray("r1"));
        this.updateMatrixRegIco(SafeJO.valueOf((JsonObject)jo).getJsonArray("r2"));
        jo = this.getMatrixIco();
        this.updateMatrixIco(jo);
    }

    private void updateRegIco(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateRegIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO sjo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            this.updMMMatrixInBranch = Math.max(this.updMMMatrixInBranch, sjo.getStringAsLong("updMMMatrixInBranch"));
            this.updMinMaxMatrixTitle = Math.max(this.updMinMaxMatrixTitle, sjo.getStringAsLong("updMinMaxMatrixTitle"));
            this.updMinMaxMatrixData = Math.max(this.updMinMaxMatrixData, sjo.getStringAsLong("updMinMaxMatrixData"));
            this.updMinMaxMatrixMotivPlan = Math.max(this.updMinMaxMatrixMotivPlan, sjo.getStringAsLong("updMinMaxMatrixMotivPlan"));
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", sjo.getStringAsLong("regId")).add("ico_id", sjo.getStringAsInt("icoId")).add("branch_id", sjo.getStringAsLong("BranchId")).add("is_motivation", sjo.getString("isMotivation").equalsIgnoreCase("1")).add("is_spr_tov", sjo.getString("isSprTov").equalsIgnoreCase("1")).add("branch_plan", sjo.getStringAsInt("branchPlan")).add("type_motiv", sjo.getStringAsInt("typeMotivation")).add("motiv_per_unit", sjo.getStringAsDouble("motivationPerUnit")).add("porog_plan", sjo.getStringAsInt("porogPlan")).add("sip_price", sjo.getStringAsDouble("sipPrice")).add("disable", sjo.getString("disable").equalsIgnoreCase("1")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_matrix_ico_4_v1", Json.createObjectBuilder().add("data", array).add("updMMMatrixInBranch", this.updMMMatrixInBranch).add("updMinMaxMatrixTitle", this.updMinMaxMatrixTitle).add("updMinMaxMatrixData", this.updMinMaxMatrixData).add("updMinMaxMatrixMotivPlan", this.updMinMaxMatrixMotivPlan)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        System.out.println("updateRegIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert + "; \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + this.cnt_update + "; \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + this.cnt_delete + ";");
    }

    private void updateMatrixRegIco(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateMatrixRegIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0");
            return;
        }
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO sjo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", sjo.getStringAsLong("regId")).add("ico_id", sjo.getStringAsInt("icoId")).add("branch_id", sjo.getStringAsLong("BranchId")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_matrix_ico_3_v1", Json.createObjectBuilder().add("data", array)));
        this.cnt_insert = response.getInt("cnt_insert");
        System.out.println("updateMatrixRegIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert);
    }

    private void updateMatrixIco(JsonObject jo) throws Throwable {
        JsonArray ja = SafeJO.valueOf((JsonObject)jo).getJsonArray("r1");
        if (ja.size() == 0) {
            System.out.println("updateMatrixIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO sjo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("res_name", sjo.getString("resName")).add("ico_id", sjo.getStringAsInt("icoId")).add("disable", !sjo.getString("disable").equalsIgnoreCase("0")).add("upd_count", sjo.getStringAsLong("updCount")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_matrix_ico_2_v1", Json.createObjectBuilder().add("data", array)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        System.out.println("updateMatrixIco \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert + "; \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + this.cnt_update + "; \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + this.cnt_delete + ";");
    }

    private JsonObject getMatrixIco() throws Throwable {
        long updCountMatrixIco = this.getUpdCount("updCountMatrixIco");
        return OLM101.SQL.executeCDB("olm101_4_v1", Json.createObjectBuilder().add("updCount", updCountMatrixIco));
    }

    private JsonObject getRegIco(String division) throws Throwable {
        this.updMMMatrixInBranch = 0L;
        this.updMinMaxMatrixTitle = 0L;
        this.updMinMaxMatrixData = 0L;
        this.updMinMaxMatrixMotivPlan = 0L;
        return OLM101.SQL.executeCDB("olm101_3_v1", Json.createObjectBuilder().add("branchId", OLM101.config.getDefaultBranchId()).add("DivisionList", division).add("updMMMatrixInBranch", this.updMMMatrixInBranch).add("updMinMaxMatrixTitle", this.updMinMaxMatrixTitle).add("updMinMaxMatrixData", this.updMinMaxMatrixData).add("updMinMaxMatrixMotivPlan", this.updMinMaxMatrixMotivPlan));
    }

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_matrix_ico_1_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }
}

