/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class MirCert
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.updatePurchaseTitle();
        this.updatePurchaseData();
        this.updateReturnTitle();
        this.updateReturnData();
    }

    private void updateReturnData() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_mir_cert_7_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.saveReturnDataOnSrv(localData.getJsonArray("r1"));
            OLM101.SQL.executeLocal("olm101_mir_cert_8_v1");
        }
    }

    private void saveReturnDataOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("NAKLTITLEID", jo.getLong("nakl_title_id")).add("NAKLDATAID", jo.getLong("nakl_data_id")).add("ARTICLENUMBER", jo.getLong("article_number")).add("TRUCODE", jo.getString("tru_code")).add("SUMCERT", jo.getDouble("sum_cert"));
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_38_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private void updateReturnTitle() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_mir_cert_5_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.saveReturnTitleOnSrv(localData.getJsonArray("r1"));
            OLM101.SQL.executeLocal("olm101_mir_cert_6_v1");
        }
    }

    private void saveReturnTitleOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsRecipeDate = jo.getTimestamp("confirmation_last_try_date");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("NAKLTITLEID", jo.getLong("nakl_title_id")).add("REFUNDPREAUTH_XREQUESTID", jo.getString("refund_pre_auth_x_request_id")).add("REFUNDPREAUTH_REQUEST", jo.getString("refund_pre_auth_request")).add("REFUNDPREAUTH_ANSWER", jo.getString("refund_pre_auth_answer")).add("RETURNBASKETID", jo.getString("return_basket_id")).add("CONFIRMATION_XREQUESTID", jo.getString("confirmation_x_request_id")).add("CONFIRMATION_REQUEST", jo.getString("confirmation_request")).add("CONFIRMATION_ANSWER", jo.getString("confirmation_answer")).add("CONFIRMATION_TRYCOUNT", jo.getInt("confirmation_try_count", 0)).add("CONFIRMATION_LASTTRYDATE", dateFormatWithMs.format(tsRecipeDate)).add("CONFIRMATION_OK", jo.getBoolean("confirmation_ok") ? "1" : "0");
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_37_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private void updatePurchaseTitle() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_mir_cert_1_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.savePurchaseTitleOnSrv(localData.getJsonArray("r1"));
            OLM101.SQL.executeLocal("olm101_mir_cert_2_v1");
        }
    }

    private void savePurchaseTitleOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsRecipeDate = jo.getTimestamp("confirmation_last_try_date");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("NAKLTITLERID", jo.getLong("nakl_title_r_id")).add("PREAUTH_XREQUESTID", jo.getString("pre_auth_request")).add("PREAUTH_REQUEST", jo.getString("pre_auth_x_request_id")).add("PREAUTH_ANSWER", jo.getString("pre_auth_answer")).add("PURCHASEBASKETID", jo.getString("purchase_basket_id")).add("CONFIRMATION_XREQUESTID", jo.getString("confirmation_x_request_id")).add("CONFIRMATION_REQUEST", jo.getString("confirmation_request")).add("CONFIRMATION_ANSWER", jo.getString("confirmation_answer")).add("CONFIRMATION_TRYCOUNT", jo.getInt("confirmation_try_count", 0)).add("CONFIRMATION_LASTTRYDATE", dateFormatWithMs.format(tsRecipeDate)).add("CONFIRMATION_OK", jo.getBoolean("confirmation_ok") ? "1" : "0");
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_35_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private void updatePurchaseData() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_mir_cert_3_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.savePurchaseDataOnSrv(localData.getJsonArray("r1"));
            OLM101.SQL.executeLocal("olm101_mir_cert_4_v1");
        }
    }

    private void savePurchaseDataOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("NAKLTITLERID", jo.getLong("nakl_title_r_id")).add("NAKLDATARID", jo.getLong("nakl_data_r_id")).add("ARTICLENUMBER", jo.getLong("article_number")).add("TRUCODE", jo.getString("tru_code")).add("SUMCERT", jo.getDouble("sum_cert"));
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_36_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }
}

