/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class NameClassifier
extends SynchroBase {
    private long updNameClassifier;
    private long updNameClassifierData;
    private long rowPartCount;
    private long rowAllCount;

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_name_class_3_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }

    @Override
    protected void doWork() throws Throwable {
        this.updateTitle();
        this.updateData();
    }

    private void updateData() throws Throwable {
        this.writeLog("\u0421\u0442\u0440\u043e\u043a\u0438. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445...");
        this.updNameClassifierData = this.getUpdCount("NameClassifierData");
        this.rowPartCount = 1L;
        this.rowAllCount = 0L;
        while (this.rowPartCount > 0L) {
            JsonArray ja = this.getPartData();
            this.rowPartCount = ja.size();
            this.rowAllCount += this.rowPartCount;
            if (this.rowPartCount > 0L) {
                this.updatePartData(ja);
            }
            this.writeLog(String.format(": \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updNameClassifierData, this.rowPartCount, this.rowAllCount));
        }
    }

    private void updatePartData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updNameClassifierData) {
                this.updNameClassifierData = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getLong("reg_id")).add("name_classifier_id", jo.getLong("name_classifier_id")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_name_class_2_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updNameClassifierData));
    }

    private JsonArray getPartData() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_name_class_2_v1", Json.createObjectBuilder().add("upd_count", this.updNameClassifierData).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }

    private void updateTitle() throws Throwable {
        this.writeLog("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445...");
        this.updNameClassifier = this.getUpdCount("NameClassifier");
        this.rowPartCount = 1L;
        this.rowAllCount = 0L;
        while (this.rowPartCount > 0L) {
            JsonArray ja = this.getPartTitle();
            this.rowPartCount = ja.size();
            this.rowAllCount += this.rowPartCount;
            if (this.rowPartCount > 0L) {
                this.updatePartTitle(ja);
            }
            this.writeLog(String.format(": \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 %d; \u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043f\u0430\u043a\u0435\u0442\u0435 %d; \u0412\u0441\u0435\u0433\u043e %d;", this.updNameClassifier, this.rowPartCount, this.rowAllCount));
        }
    }

    private void updatePartTitle(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updNameClassifier) {
                this.updNameClassifier = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("parent_id", jo.getLong("parent_id")).add("name_classifier_id", jo.getLong("name_classifier_id")).add("name", jo.getString("name")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_name_class_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updNameClassifier));
    }

    private JsonArray getPartTitle() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_name_class_1_v1", Json.createObjectBuilder().add("upd_count", this.updNameClassifier).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }
}

