/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Permission
extends SynchroBase {
    private String userIds;
    private String accessPointIds;

    @Override
    protected void doWork() throws Throwable {
        this.userIds = this.getUserIdList();
        this.accessPointIds = this.getAccessPointIdList();
        if (!this.userIds.isEmpty() && !this.accessPointIds.isEmpty()) {
            this.updateAccessPointRule(this.getAccessLevel());
        }
    }

    private void updateAccessPointRule(JsonArray ja) throws Throwable {
        this.resetCounter();
        this.cnt_receive = ja.size();
        OLM101.SQL.executeLocal("olm101_permission_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)ja));
        System.out.println("\u041f\u0440\u0430\u0432\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0410\u0420\u041c. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getAccessLevel() throws Throwable {
        SafeJO sjo = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_permission_2_v1", Json.createObjectBuilder().add("user", this.userIds).add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("access_points", this.accessPointIds)));
        return sjo.getJsonArray("r1");
    }

    private String getUserIdList() throws Throwable {
        SafeJO ids = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_permission_1_v1"));
        return ids.getString("user");
    }

    private String getAccessPointIdList() throws Throwable {
        SafeJO ids = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_permission_1_v1", Json.createObjectBuilder()));
        return ids.getString("access_point");
    }
}

