/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class PresentProducts
extends SynchroBase {
    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_present_2_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        JsonArray ja = this.getData();
        if (ja.size() > 0) {
            this.updateData(ja);
        } else {
            System.out.println("\u041f\u043e\u0434\u0430\u0440\u043a\u0438. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
        }
    }

    private void updateData(JsonArray ja) throws Throwable {
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long _updCount = jo.getStringAsLong("updCount");
            if (_updCount > this.updCount) {
                this.updCount = _updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getStringAsLong("RegID")).add("disable", jo.getStringAsBoolean("Disable")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_present_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updCount)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter();
    }

    private JsonArray getData() throws Throwable {
        this.updCount = this.getUpdCount("PresentProducts");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_29_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("upd_count", this.updCount))).getJsonArray("r1");
    }
}

