/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Recipe
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.saveTitle();
        this.saveData();
    }

    private void saveData() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_recipe_3_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.saveDataOnSrv(localData.getJsonArray("r1"));
            this.updateDataStatus();
        }
    }

    private void saveDataOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("nakl_data_r_id", jo.getLong("nakl_data_r_id"));
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_31_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private void updateDataStatus() throws Throwable {
        OLM101.SQL.executeLocal("olm101_recipe_4_v1");
    }

    private void saveTitle() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_recipe_1_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            this.saveTitleOnSrv(localData.getJsonArray("r1"));
            this.updateTitleStatus();
        }
    }

    private void saveTitleOnSrv(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsRecipeDate = jo.getTimestamp("recipe_date");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("recept_type_id", jo.getLong("recept_type_id")).add("recipe_date", dateFormatWithoutTime.format(tsRecipeDate)).add("recipe_seria", jo.getString("recipe_seria")).add("recipe_number", jo.getString("recipe_number")).add("recipe_patient", jo.getString("recipe_patient"));
            array.add((JsonValue)jBuild.build());
        }
        OLM101.SQL.executeCDB("olm101_30_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private void updateTitleStatus() throws Throwable {
        OLM101.SQL.executeLocal("olm101_recipe_2_v1");
    }
}

