/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Registry
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.updateRegistry(this.getRegData(this.getRegIdList()));
    }

    private void updateRegistry(JsonArray regData) throws Throwable {
        this.resetCounter();
        this.cnt_receive = regData.size();
        if (this.cnt_receive > 0) {
            OLM101.SQL.executeLocal("olm101_reg_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)regData));
        }
        System.out.println("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0442\u043e\u0432\u0430\u0440\u043e\u0432. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getRegData(String regIdList) throws Throwable {
        if (regIdList.isEmpty()) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_reg_1_v1", Json.createObjectBuilder().add("reg_id", regIdList)));
        return response.getJsonArray("r1");
    }

    private String getRegIdList() throws Throwable {
        SafeJO ids = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_reg_1_v1"));
        return ids.getString("reg_id_list");
    }
}

