/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.bean.SumKKM;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.config.Variables;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Returns
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        this.synchroReturnsTitle();
        this.synchroReturnsData();
        this.deleteOldCheck();
        this.checkSumKKM();
    }

    private void checkSumKKM() throws Throwable {
        String divisions = Param.getDivision().equalsIgnoreCase("" + OLM101.config.getDefaultBranchId()) || Param.getDivision().isEmpty() ? "" : Param.getDivision();
        for (SumKKM aSumKKM : Variables.sumKKMList) {
            OLM101.SQL.executeCDB("olm101_36_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branchId", OLM101.config.getDefaultBranchId()).add("deviceId", aSumKKM.getDeviceId()).add("sessionNumber", aSumKKM.getNumberSession()).add("lastDocDate", dateFormatWithMs.format(aSumKKM.getCreateDate())).add("sumKKM", aSumKKM.getSumKKM()).add("DivisionList", divisions));
        }
    }

    private void deleteOldCheck() throws Throwable {
        OLM101.SQL.executeLocal("olm101_returns_5_v1");
    }

    private void synchroReturnsData() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_returns_3_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            JsonArray srvId = this.getSrvDataId(localData);
            this.updateReturnsDate(srvId);
        }
    }

    private void updateReturnsDate(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("srv_nakl_data_id", jo.getStringAsLong("SRV_NAKLDATAID")).add("nakl_data_id", jo.getStringAsLong("NAKLDATAID")).build());
        }
        OLM101.SQL.executeLocal("olm101_returns_4_v1", Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private JsonArray getSrvDataId(SafeJO localData) throws Throwable {
        JsonArrayBuilder array1 = Json.createArrayBuilder();
        JsonArray jaR1 = localData.getJsonArray("r1");
        for (int i = 0; i < jaR1.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)jaR1.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_title_id", jo.getLong("nakl_title_id")).add("nakl_data_id", jo.getLong("nakl_data_id")).add("reg_id", jo.getLong("reg_id")).add("quantity", jo.getDouble("quantity")).add("price_rozn_w_nds", jo.getDouble("price_rozn_w_nds")).add("srv_nakl_data_r_id", jo.getLong("srv_nakl_data_r_id")).add("parent_nakl_data_id", jo.getLong("parent_nakl_data_id")).add("srv_nakl_data_id", jo.getLong("srv_nakl_data_id"));
            array1.add((JsonValue)jBuild.build());
        }
        JsonArrayBuilder array2 = Json.createArrayBuilder();
        JsonArray jaR2 = localData.getJsonArray("r2");
        for (int i = 0; i < jaR2.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)jaR2.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_data_id", jo.getLong("nakl_data_id")).add("gtin", jo.getLong("gtin")).add("sn", jo.getString("sn")).add("quantity", jo.getDouble("quantity")).add("return_reason", jo.getLong("return_reason"));
            array2.add((JsonValue)jBuild.build());
        }
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_35_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("r1", (JsonValue)array1.build()).add("r2", (JsonValue)array2.build())));
        return srvData.getJsonArray("r1");
    }

    private void synchroReturnsTitle() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_returns_1_v1"));
        if (localData.getJsonArraySize("r1") > 0) {
            JsonArray srvId = this.getSrvTitleId(localData.getJsonArray("r1"));
            this.updateReturnsTitle(srvId);
        }
    }

    private void updateReturnsTitle(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("srv_nakl_title_id", jo.getStringAsLong("Srv_NaklTitleID")).add("nakl_title_id", jo.getStringAsLong("NaklTitleID")).build());
        }
        OLM101.SQL.executeLocal("olm101_returns_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)array.build()));
    }

    private JsonArray getSrvTitleId(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsCreateDate = jo.getTimestamp("create_date");
            Timestamp tsFnDocumentDate = jo.getTimestamp("fn_document_date");
            long branchId = jo.getLong("branch_id");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_title_id", jo.getLong("nakl_title_id")).add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("user_id", jo.getLong("user_id")).add("doc_type_id", jo.getLong("doc_type_id")).add("create_date", dateTimeFormat.format(tsCreateDate)).add("device_id", jo.getLong("device_id")).add("number_session", jo.getLong("number_session", 0L)).add("is_post", jo.getString("is_post")).add("srv_nakl_title_id", jo.getLong("srv_nakl_title_id")).add("doctor_list_id", jo.getLong("doctor_list_id")).add("fn_factory_number", jo.getString("fn_factory_number")).add("fn_document_number", jo.getLong("fn_document_number")).add("fn_fiscal_sign", jo.getLong("fn_fiscal_sign")).add("fn_document_date", dateTimeFormat.format(tsFnDocumentDate)).add("branch_id", branchId > 0L ? branchId : OLM101.config.getDefaultBranchId());
            array.add((JsonValue)jBuild.build());
        }
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_34_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("r1", (JsonValue)array.build())));
        return srvData.getJsonArray("r1");
    }
}

