/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.bean.SumKKM;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.config.Variables;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Sales
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        if (Param.getSyncType() == Param.SyncType.QUICK) {
            ++Variables.syncSalesFailCounter;
        }
        this.synchroNaklTitleR();
        this.synchroNaklDataR();
        this.synchroSubsidizedMedicines();
        this.deleteFinishedCheck();
        this.synchroNaklDataRBonus();
        this.synchroDataMatrixR();
        Variables.syncSalesFailCounter = 0;
    }

    private void synchroDataMatrixR() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_10_v1"));
        if (localData.getJsonArraySize("r1") == 0) {
            return;
        }
        OLM101.SQL.executeCDB("olm101_11_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)this.readDataMatrixR(localData.getJsonArray("r1"))));
        this.deleteDataMatrixR();
    }

    private JsonArray readDataMatrixR(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_data_r_id", jo.getLong("nakl_data_r_id")).add("gtin", jo.getLong("gtin")).add("sn", jo.getString("sn")).add("qnt", jo.getInt("qnt")).add("ratio", jo.getInt("ratio")).add("spr_ed_izm_id", jo.getLong("spr_ed_izm_id"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void deleteDataMatrixR() throws Throwable {
        OLM101.SQL.executeLocal("olm101_sales_11_v1");
    }

    private void synchroNaklDataRBonus() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_8_v1"));
        if (localData.getJsonArraySize("r1") == 0) {
            return;
        }
        OLM101.SQL.executeCDB("olm101_10_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)this.readNaklDataRBonus(localData.getJsonArray("r1"))));
        this.deleteNaklDataRBonus();
    }

    private JsonArray readNaklDataRBonus(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("nakl_data_r_id", jo.getLong("nakl_data_r_id")).add("i_discount_id", jo.getLong("i_discount_id")).add("sum_bonus", jo.getDouble("sum_bonus")).add("fixed_price", jo.getDouble("fixed_price")).add("sum_sertificate", jo.getDouble("sum_sertificate")).add("is_mir_cert", jo.getBoolean("is_mir_cert") ? "1" : "0");
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void deleteNaklDataRBonus() throws Throwable {
        OLM101.SQL.executeLocal("olm101_sales_9_v1");
    }

    private void deleteFinishedCheck() throws Throwable {
        OLM101.SQL.executeLocal("olm101_sales_7_v1");
    }

    private void synchroSubsidizedMedicines() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_5_v1"));
        if (localData.getJsonArraySize("r1") == 0) {
            return;
        }
        OLM101.SQL.executeCDB("olm101_9_v1", ISQL.FuncType.WRITE_ONLY, Json.createObjectBuilder().add("r1", (JsonValue)this.readSubsidizedMedicines(localData.getJsonArray("r1"))));
        this.deleteSubsidizedMedicines();
    }

    private void deleteSubsidizedMedicines() throws Throwable {
        OLM101.SQL.executeLocal("olm101_sales_6_v1");
    }

    private JsonArray readSubsidizedMedicines(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            Timestamp time_add = jo.getTimestamp("recipe_date");
            if (time_add.getTime() > 0L) {
                jBuild.add("recipe_date", dateFormat.format(time_add));
            } else {
                jBuild.addNull("recipe_date");
            }
            jBuild.add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("number", jo.getString("number")).add("seria", jo.getString("seria")).add("patient", jo.getString("patient")).add("comment_b64", jo.getString("comment_b64")).add("doctor_id", jo.getLong("doctor_id")).add("hospital_id", jo.getLong("hospital_id")).add("w_letter_summ", jo.getDouble("w_letter_summ")).add("w_letter_num", jo.getString("w_letter_num"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void synchroNaklDataR() throws Throwable {
        SafeJO localData;
        boolean isFasovkaDeleted = this.getKFSParam("FasovkaDeleted").trim().equalsIgnoreCase("1");
        if (isFasovkaDeleted) {
            this.setKFSParam("FasovkaDeleted", "0");
        }
        if ((localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_3_v1", Json.createObjectBuilder().add("is_fasovka_del", isFasovkaDeleted)))).getJsonArraySize("r1") == 0) {
            return;
        }
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_8_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)this.readNaklDataR(localData.getJsonArray("r1")))));
        this.setSrvNaklDataRId(srvData.getJsonArray("r1"));
    }

    private JsonArray readNaklDataR(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            Timestamp time_add = jo.getTimestamp("time_add");
            if (time_add.getTime() > 0L) {
                jBuild.add("time_add", dateFormat.format(time_add));
            } else {
                jBuild.addNull("time_add");
            }
            jBuild.add("srv_nakl_title_r_id", jo.getLong("srv_nakl_title_r_id")).add("nakl_data_id", jo.getLong("nakl_data_id")).add("quantity", jo.getDouble("quantity")).add("sum_rozn_w_nds", jo.getDouble("sum_rozn_w_nds")).add("discount_id", jo.getLong("discount_id")).add("u_quantity", jo.getDouble("u_quantity")).add("tovar_ed_izm_id", jo.getLong("tovar_ed_izm_id")).add("disable", jo.getBoolean("disable") ? "1" : "0").add("nakl_data_r_id", jo.getLong("nakl_data_r_id")).add("srv_nakl_data_r_id", jo.getLong("srv_nakl_data_r_id")).add("nds", jo.getInt("nds", 0)).add("is_5d", jo.getBoolean("is_5d") ? "1" : "0");
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void setSrvNaklDataRId(JsonArray ja) throws Throwable {
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("Srv_NaklDataRID", jo.getStringAsLong("Srv_NaklDataRID")).add("NaklDataRID", jo.getStringAsLong("NaklDataRID")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_4_v1", Json.createObjectBuilder().add("r1", (JsonValue)array.build())));
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0447\u0438\u044f \u0441\u0442\u0440\u043e\u043a\u0438 \u0447\u0435\u043a\u043e\u0432: ", EnumSet.of(SynchroBase.Counter.UPDATE));
    }

    private void synchroNaklTitleR() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_1_v1", Json.createObjectBuilder().add("quick_sync", Param.getSyncType() == Param.SyncType.QUICK).add("branch_id", OLM101.config.getDefaultBranchId())));
        if (!localData.getBoolean("is_exists")) {
            return;
        }
        SumKKM.fullSumKKM(Variables.sumKKMList, localData.getJsonArray("r1"));
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_7_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("r1", (JsonValue)this.readNaklTitleR(localData.getJsonArray("r2")))));
        this.setSrvNaklTitleRId(srvData.getJsonArray("r1"));
    }

    private JsonArray readNaklTitleR(JsonArray ja) {
        int moscowOffset = Sales.getMoscowOffsetInMinute();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            String guid = jo.getString("guid");
            if (guid.isEmpty()) {
                UUID uuid = UUID.randomUUID();
                guid = uuid.toString().toUpperCase();
            }
            Timestamp create_date = jo.getTimestamp("create_date");
            Timestamp fn_doc_date = jo.getTimestamp("fn_document_date");
            Timestamp create_date_msk = new Timestamp(0L);
            if (create_date.getTime() > 0L) {
                create_date_msk.setTime(create_date.getTime() - TimeUnit.MINUTES.toMillis(moscowOffset));
                jBuild.add("create_date", dateTimeFormat.format(create_date));
                jBuild.add("create_date_msk", dateTimeFormat.format(create_date_msk));
            } else {
                jBuild.addNull("create_date");
                jBuild.addNull("create_date_msk");
            }
            if (fn_doc_date.getTime() > 0L) {
                jBuild.add("fn_document_date", dateTimeFormat.format(fn_doc_date));
            } else {
                jBuild.addNull("fn_document_date");
            }
            jBuild.add("nakl_title_r_id", jo.getLong("nakl_title_r_id")).add("user_id", jo.getLong("user_id")).add("doc_type_id", jo.getLong("doc_type_id")).add("device_id", jo.getString("device_id")).add("number_session", jo.getLong("number_session")).add("autorization_code", jo.getString("autorization_code").replaceAll("\"", "")).add("is_post", jo.getString("is_post")).add("srv_nakl_title_r_id", jo.getLong("srv_nakl_title_r_id")).add("doctor_list_id", jo.getLong("doctor_list_id")).add("inner_number", jo.getString("inner_number")).add("guid", guid).add("code_lpu_for_nls_id", jo.getLong("code_lpu_for_nls_id")).add("is_new_prepay", jo.getString("is_new_prepay")).add("fn_factory_number", jo.getString("fn_factory_number")).add("fn_document_number", jo.getLong("fn_document_number")).add("fn_fiscal_sign", jo.getLong("fn_fiscal_sign")).add("branch_id", jo.getLong("branch_id")).add("buyer_name", jo.getString("buyer_name")).add("buyer_inn", jo.getString("buyer_inn")).add("is_sale_by_static_qrcode", jo.getString("is_sale_by_static_qrcode")).add("customer_storage_order_id", jo.getLong("customer_storage_order_id")).add("prepay_id", jo.getLong("prepay_id")).add("is_sale_by_dynamic_qrcode", jo.getString("is_sale_by_dynamic_qrcode")).add("dynamic_qrcode_id", jo.getString("dynamic_qrcode_id")).add("qr_guid", jo.getString("qr_guid"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }

    private void setSrvNaklTitleRId(JsonArray ja) throws Throwable {
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("naklTitleRId", jo.getStringAsLong("naklTitleRId")).add("local_NaklTitleRId", jo.getStringAsLong("local_NaklTitleRId")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_sales_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)array.build()).add("customerId", OLM101.config.getCustomerId())));
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0447\u0438\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u043e\u0432 \u0447\u0435\u043a\u043e\u0432: ", EnumSet.of(SynchroBase.Counter.UPDATE));
    }
}

