/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class SavePlace
extends SynchroBase {
    private long updSavePlace = 0L;

    @Override
    protected void doWork() throws Throwable {
        this.updateSavePlace(SafeJO.valueOf((JsonObject)this.getSavePlace()).getJsonArray("r1"));
    }

    private void updateSavePlace(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateSavePlace \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        this.cnt_receive = ja.size();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double savePlaceId = jo.getDouble("save_place_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updSavePlace) {
                this.updSavePlace = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_save_place_id", savePlaceId).add("branch_id", jo.getLong("branch_id")).add("save_place_id", Double.valueOf(savePlaceId).longValue()).add("save_place_name", jo.getString("save_place_name")).add("disable", jo.getBoolean("disable")).build());
        }
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_save_place_1_v1", Json.createObjectBuilder().add("data", array).add("upd_count", this.updSavePlace)));
        this.cnt_delete = response.getInt("cnt_delete");
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        System.out.println("updateSavePlace \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive + "; \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.cnt_insert + "; \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + this.cnt_update + "; \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + this.cnt_delete + ";");
    }

    private JsonObject getSavePlace() throws Throwable {
        this.updSavePlace = this.getUpdCount("save_place");
        return OLM101.SQL.executeRDB("olm101_save_place_1_v1", Json.createObjectBuilder().add("upd_count", this.updSavePlace).add("division_list", Param.getDivision()));
    }

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_save_place_2_v1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }
}

