/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.Base64;
import java.util.HashMap;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.config.Variables;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class ServerOptions
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        HashMap<String, String> SrvOptions = new HashMap<String, String>();
        JsonObject jo = OLM101.SQL.executeRDB("olm101_srv_opt_1_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("division", Param.getDivision()));
        this.readOptions(jo, SrvOptions);
        this.setKFSParam(SrvOptions);
    }

    private void readOptions(JsonObject jo, HashMap<String, String> SrvOptions) throws Throwable {
        SafeJO sjo = SafeJO.valueOf((JsonObject)jo);
        Variables.srvoptDiscountype = sjo.getBoolean("discount_type");
        SrvOptions.put("DISCOUNTTYPE", Variables.srvoptDiscountype ? "1" : "0");
        Variables.srvoptRoundingDiscount = sjo.getInt("rounding_discount", 0);
        SrvOptions.put("ROUNDINGDISCOUNT", String.valueOf(Variables.srvoptRoundingDiscount));
        SrvOptions.put("UnvisibleDiscount", sjo.getBoolean("unvisible_discount") ? "1" : "0");
        SrvOptions.put("AddTovOnlyByBarcode", sjo.getBoolean("add_tov_only_by_barcode") ? "1" : "0");
        SrvOptions.put("CHECKNLS", sjo.getBoolean("check_nls") ? "1" : "0");
        SrvOptions.put("discountPercent", String.valueOf(sjo.getInt("discount_percent", 0)));
        SrvOptions.put("discountPercentJV", String.valueOf(sjo.getInt("discount_percent_jnvls", 0)));
        SrvOptions.put("isVisiblePercentDiscountForOst", sjo.getBoolean("is_visible_percent_discount_for_ost") ? "1" : "0");
        SrvOptions.put("CALC_AMOUNT_IN_CASH", sjo.getBoolean("amount_in_cash") ? "1" : "0");
        Variables.srvoptRoundingDiscountType = sjo.getInt("rounding_discount_type", 0);
        SrvOptions.put("RoundingDiscountType", String.valueOf(Variables.srvoptRoundingDiscountType));
        SrvOptions.put("FORMINGPKO", sjo.getBoolean("forming_pko") ? "1" : "0");
        SrvOptions.put("TAXMODE", String.valueOf(sjo.getInt("tax_mode", 0)));
        Variables.srvoptWriteOffAfterClose = sjo.getBoolean("write_off_after_close");
        SrvOptions.put("writeOffAfterClose", Variables.srvoptWriteOffAfterClose ? "1" : "0");
        SrvOptions.put("ShowActsOnStartSession", sjo.getBoolean("show_acts_on_start_session") ? "1" : "0");
        SrvOptions.put("UseDynamicQRCodePayments", sjo.getBoolean("use_dynamic_qr_code_payments") ? "1" : "0");
        SrvOptions.put("ask_bonus_sms", sjo.getBoolean("ask_bonus_sms") ? "1" : "0");
        SrvOptions.put("ask_bonus_sms_type", String.valueOf(sjo.getInt("ask_bonus_sms_type", 0)));
        SrvOptions.put("print_electronic_check", String.valueOf(sjo.getInt("print_electronic_check", 0)));
        SrvOptions.put("UseQRCodePayments", sjo.getBoolean("use_qr_code_payments") ? "1" : "0");
        SrvOptions.put("print_promo_check", sjo.getBoolean("print_promo_check") ? "1" : "0");
        SrvOptions.put("promo_check_start_sum", ServerOptions.getDoubleStr(sjo.getDouble("promo_check_start_sum")));
        SrvOptions.put("promo_check_discount_id", String.valueOf(sjo.getInt("promo_check_discount_id", 0)));
        this.setPromoCheckText(sjo.getString("promo_check_text_b64"));
        SrvOptions.put("uds_api_auth", Base64.getEncoder().encodeToString((sjo.getString("uds_company_id") + ":" + sjo.getString("uds_api_key")).getBytes()));
        SrvOptions.put("e1rx_store_external_id", sjo.getString("e1rx_store_external_id"));
        SrvOptions.put("round_cash_itog", sjo.getBoolean("round_cash_itog") ? "1" : "0");
        this.setDivisionTaxMode(sjo.getJsonArray("division"));
    }

    private void setDivisionTaxMode(JsonArray jar) throws Throwable {
        for (int i = 0; i < jar.size(); ++i) {
            SafeJO sjo = SafeJO.valueOf((JsonObject)jar.getJsonObject(i));
            this.setKFSParam("TAXMODE", String.valueOf(sjo.getInt("tax_mode", 0)), sjo.getLong("branch_id"));
        }
    }

    private void setPromoCheckText(String check_text) throws Throwable {
        OLM101.SQL.executeLocal("olm101_srv_opt_1_v1", Json.createObjectBuilder().add("check_text", check_text).add("branch_id", OLM101.config.getDefaultBranchId()));
    }
}

