/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class Session
extends SynchroBase {
    @Override
    protected void doWork() throws Throwable {
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_session_1_v1", Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("division", Param.getDivision().equalsIgnoreCase("" + OLM101.config.getDefaultBranchId()) || Param.getDivision().isEmpty() ? "" : Param.getDivision())));
        if (localData.getJsonArraySize("r1") > 0) {
            JsonArray srvData = this.getSrvData(this.readSession(localData.getJsonArray("r1")));
            this.updateNumberSession(srvData);
        }
    }

    private void updateNumberSession(JsonArray ja) throws Throwable {
        if (ja.size() > 0) {
            OLM101.SQL.executeLocal("olm101_session_2_v1", Json.createObjectBuilder().add("r1", (JsonValue)ja));
        }
    }

    private JsonArray getSrvData(JsonArray localData) throws Throwable {
        SafeJO srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_14_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("branch_id", OLM101.config.getDefaultBranchId()).add("r1", (JsonValue)localData)));
        JsonArray ja = srvData.getJsonArray("r1");
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            array.add((JsonValue)Json.createObjectBuilder().add("number_session", jo.getStringAsLong("SessionNumber")).add("local_num", jo.getStringAsLong("LocalSessionNumber")).add("device_id", jo.getString("DeviceID")).build());
        }
        return array.build();
    }

    private JsonArray readSession(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            Timestamp tsOpen = jo.getTimestamp("open_time");
            Timestamp tsClose = jo.getTimestamp("close_time");
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("local_num", jo.getInt("local_num", 0)).add("number_session", jo.getInt("number_session", 0)).add("open_time", tsOpen.getTime() == 0L ? "" : dateTimeFormat.format(tsOpen)).add("close_time", tsClose.getTime() == 0L ? "" : dateTimeFormat.format(tsClose)).add("kkm_number", jo.getInt("kkm_number", 0)).add("device_id", jo.getString("device_id")).add("branch_id", jo.getLong("branch_id"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }
}

