/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.SynchroThread;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.util.SafeJO;

public abstract class SynchroBase {
    protected long updCount;
    protected int cnt_receive;
    protected int cnt_delete;
    protected int cnt_insert;
    protected int cnt_update;
    protected int cnt_send;
    public static int errorCount;
    public static final SimpleDateFormat dateFormatUTC;
    public static final SimpleDateFormat dateFormat;
    public static final SimpleDateFormat dateTimeFormat;
    public static final SimpleDateFormat dateFormatWithoutTime;
    public static final SimpleDateFormat dateFormatWithMs;

    public void synchro() {
        if (SynchroThread.isStop() && Param.getSyncType() != Param.SyncType.QUICK) {
            return;
        }
        try {
            this.writeLog("\u041d\u0430\u0447\u0430\u043b\u043e \u0440\u0430\u0431\u043e\u0442\u044b ...");
            this.doWork();
            this.writeLog("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e: OK.");
        }
        catch (Throwable t) {
            ++errorCount;
            OLM101.writeError(t);
        }
    }

    public void deleteOldData() throws Throwable {
    }

    protected void resetCounter() {
        this.cnt_receive = 0;
        this.cnt_delete = 0;
        this.cnt_insert = 0;
        this.cnt_update = 0;
    }

    protected void printCounter() {
        this.printCounter("", EnumSet.of(Counter.RECEIVE, Counter.DELETE, Counter.UPDATE, Counter.INSERT));
    }

    protected void printCounter(String prefix, EnumSet<Counter> eset) {
        StringBuilder sb = new StringBuilder(prefix);
        if (eset.contains((Object)Counter.RECEIVE)) {
            sb.append("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: ").append(this.cnt_receive).append("; ");
        }
        if (eset.contains((Object)Counter.INSERT)) {
            sb.append("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e: ").append(this.cnt_insert).append("; ");
        }
        if (eset.contains((Object)Counter.UPDATE)) {
            sb.append("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e: ").append(this.cnt_update).append("; ");
        }
        if (eset.contains((Object)Counter.DELETE)) {
            sb.append("\u0423\u0434\u0430\u043b\u0435\u043d\u043e: ").append(this.cnt_delete).append("; ");
        }
        if (eset.contains((Object)Counter.UPD_COUNT)) {
            sb.append("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a: ").append(this.updCount).append("; ");
        }
        if (eset.contains((Object)Counter.SEND)) {
            sb.append("\u041a\u043e\u043b-\u0432\u043e \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0441\u0442\u0440\u043e\u043a: ").append(this.cnt_send).append("; ");
        }
        this.writeLog(sb.toString());
    }

    protected abstract void doWork() throws Throwable;

    protected long getUpdCount(String spr_name) throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("get_spr_upd_count_1_v1", Json.createObjectBuilder().add("spr_name", spr_name)));
        return response.getLong("upd_count");
    }

    public void writeLog(String msg) {
        String className = this.getClass().getSimpleName();
        OLM101.writeLog(className + ": " + msg);
    }

    protected String getKFSParam(String paramName) throws Throwable {
        return this.getKFSParam(paramName, 0L);
    }

    protected String getKFSParam(String paramName, long branchId) throws Throwable {
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_3_v1", Json.createObjectBuilder().add("param_name", paramName).add("branch_id", branchId)));
        return response.getString("param_value");
    }

    protected void setKFSParam(String param, String value, long branchId) throws Throwable {
        JsonObject jParam = Json.createObjectBuilder().add("data", Json.createArrayBuilder().add(Json.createObjectBuilder().add("param", param).add("value", value).add("branch_id", branchId))).build();
        OLM101.SQL.executeLocal("olm101_kfsparam_2_v1", jParam);
    }

    protected void setKFSParam(String param, String value) throws Throwable {
        JsonObject jParam = Json.createObjectBuilder().add("data", Json.createArrayBuilder().add(Json.createObjectBuilder().add("param", param).add("value", value))).build();
        this.saveKFSParam(jParam);
    }

    protected void setKFSParam(HashMap<String, String> params) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            array.add((JsonValue)Json.createObjectBuilder().add("param", entry.getKey()).add("value", entry.getValue()).build());
        }
        JsonObject jParam = Json.createObjectBuilder().add("data", array).build();
        this.saveKFSParam(jParam);
    }

    private void saveKFSParam(JsonObject jParam) throws Throwable {
        OLM101.SQL.executeLocal("olm101_kfsparam_1_v1", jParam);
    }

    protected static String getDoubleStr(double value) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("#0.00", decimalFormatSymbols);
        return formatter.format(value);
    }

    protected static String formatDateTimeUTC(Timestamp tsTime) {
        TimeZone tzLocal = TimeZone.getDefault();
        Timestamp tsTimeUTC = new Timestamp(0L);
        int offsetLocal = Double.valueOf((double)tzLocal.getOffset(System.currentTimeMillis()) / 60000.0).intValue();
        tsTimeUTC.setTime(tsTime.getTime() - TimeUnit.MINUTES.toMillis(offsetLocal));
        return dateFormatUTC.format(tsTimeUTC);
    }

    protected static int getMoscowOffsetInMinute() {
        TimeZone tzLocal = TimeZone.getDefault();
        TimeZone tzMoscow = TimeZone.getTimeZone("Europe/Moscow");
        double offsetLocal = (double)tzLocal.getOffset(System.currentTimeMillis()) / 60000.0;
        double offsetMoscow = (double)tzMoscow.getOffset(System.currentTimeMillis()) / 60000.0;
        return Double.valueOf(offsetLocal).intValue() - Double.valueOf(offsetMoscow).intValue();
    }

    protected long getCustomerIDForXLS(String dataType) throws Throwable {
        SafeJO jo = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_22_v1", Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("data_type", dataType)));
        SafeJO.saveToFile((String)"c:\\olm101_22_v1.json", (JsonObject)jo.getInstance());
        return jo.getStringAsLong("CustomerIDFor" + dataType);
    }

    static {
        dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        dateTimeFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        dateFormatWithoutTime = new SimpleDateFormat("dd.MM.yyyy");
        dateFormatWithMs = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
    }

    public static enum Counter {
        RECEIVE,
        DELETE,
        INSERT,
        UPDATE,
        UPD_COUNT,
        SEND;

    }
}

