/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class TLS
extends SynchroBase {
    private long updTLS;

    @Override
    public void deleteOldData() throws Throwable {
        OLM101.SQL.executeLocal("olm101_tls_2_v1");
    }

    @Override
    protected void doWork() throws Throwable {
        this.setUpdTLS();
        JsonArray ja = this.getData();
        if (ja.size() > 0) {
            this.updateData(ja);
        }
    }

    private void setUpdTLS() throws Throwable {
        this.updTLS = this.getUpdCount("updTLS");
    }

    private void updateData(JsonArray ja) throws Throwable {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updTLS) {
                this.updTLS = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("reg_id", jo.getLong("reg_id")).add("disable", jo.getBoolean("disable")).add("is_blank", jo.getInt("blank_id", 0) > 0).build());
        }
        OLM101.SQL.executeLocal("olm101_tls_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updTLS));
    }

    private JsonArray getData() throws Throwable {
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_tls_1_v1", Json.createObjectBuilder().add("upd_count", this.updTLS).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }
}

