/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class TherapeuticChain
extends SynchroBase {
    private long updTherChainGeneral = 0L;
    private long updTherChainIndividual = 0L;
    private long updTherChainDrug = 0L;
    private long updTherChainMNN = 0L;

    @Override
    protected void doWork() throws Throwable {
        this.updateTherChainGeneral(this.getTherChainGeneral());
        this.updateTherChainIndividual(this.getTherChainIndividual());
        this.updateTherChainDrug(this.getTherChainDrug());
        this.updateTherChainMNN(this.getTherChainMNN());
    }

    private void updateTherChainMNN(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateTherChainMNN \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double therChainId = jo.getDouble("ther_chain_id");
            double therChainMnnId = jo.getDouble("ther_chain_mnn_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updTherChainMNN) {
                this.updTherChainMNN = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_ther_chain_id", therChainId).add("rbd_ther_chain_mnn_id", therChainMnnId).add("ther_chain_id", Double.valueOf(therChainId).longValue()).add("ther_chain_mnn_id", Double.valueOf(therChainMnnId).longValue()).add("mnn_id", jo.getLong("mnn_id")).add("date_modify", jo.getString("date_modify")).add("user_name", jo.getString("user_name")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_ther_chain_4_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updTherChainMNN));
        System.out.println("updateTherChainMNN \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getTherChainMNN() throws Throwable {
        this.updTherChainMNN = this.getUpdCount("updTherChainMNN");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_ther_chain_4_v1", Json.createObjectBuilder().add("upd_count", this.updTherChainMNN).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }

    private void updateTherChainDrug(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateTherChainDrug \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double therChainId = jo.getDouble("ther_chain_id");
            double therChainDrugId = jo.getDouble("ther_chain_drug_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updTherChainDrug) {
                this.updTherChainDrug = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_ther_chain_id", therChainId).add("rbd_ther_chain_drug_id", therChainDrugId).add("ther_chain_id", Double.valueOf(therChainId).longValue()).add("ther_chain_drug_id", Double.valueOf(therChainDrugId).longValue()).add("drug_id", jo.getLong("drug_id")).add("date_modify", jo.getString("date_modify")).add("user_name", jo.getString("user_name")).add("disable", jo.getBoolean("disable")).build());
        }
        OLM101.SQL.executeLocal("olm101_ther_chain_3_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updTherChainDrug));
        System.out.println("updateTherChainDrug \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getTherChainDrug() throws Throwable {
        this.updTherChainDrug = this.getUpdCount("updTherChainDrug");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_ther_chain_3_v1", Json.createObjectBuilder().add("upd_count", this.updTherChainDrug).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }

    private void updateTherChainIndividual(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateTherChainIndividual \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double therChainId = jo.getDouble("ther_chain_id");
            double parentId = jo.getDouble("parent_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updTherChainIndividual) {
                this.updTherChainIndividual = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_ther_chain_id", therChainId).add("ther_chain_id", Double.valueOf(therChainId).longValue()).add("parent_id", Double.valueOf(parentId).longValue()).add("name", jo.getString("name")).add("date_modify", jo.getString("date_modify")).add("user_name", jo.getString("user_name")).add("disable", jo.getBoolean("disable")).add("visible", jo.getBoolean("visible")).build());
        }
        OLM101.SQL.executeLocal("olm101_ther_chain_2_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updTherChainIndividual));
        System.out.println("updateTherChainIndividual \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getTherChainIndividual() throws Throwable {
        this.updTherChainIndividual = this.getUpdCount("updTherChainIndividual");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_ther_chain_2_v1", Json.createObjectBuilder().add("upd_count", this.updTherChainIndividual).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }

    private void updateTherChainGeneral(JsonArray ja) throws Throwable {
        if (ja.size() == 0) {
            System.out.println("updateTherChainGeneral \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: 0;");
            return;
        }
        this.resetCounter();
        this.cnt_receive = ja.size();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < this.cnt_receive; ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            double therChainId = jo.getDouble("ther_chain_id");
            double parentId = jo.getDouble("parent_id");
            long updCount = jo.getLong("upd_count");
            if (updCount > this.updTherChainGeneral) {
                this.updTherChainGeneral = updCount;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("rbd_ther_chain_id", therChainId).add("ther_chain_id", Double.valueOf(therChainId).longValue()).add("parent_id", Double.valueOf(parentId).longValue()).add("name", jo.getString("name")).add("date_modify", jo.getString("date_modify")).add("user_name", jo.getString("user_name")).add("disable", jo.getBoolean("disable")).add("visible", jo.getBoolean("visible")).build());
        }
        OLM101.SQL.executeLocal("olm101_ther_chain_1_v1", Json.createObjectBuilder().add("r1", array).add("upd_count", this.updTherChainGeneral));
        System.out.println("updateTherChainGeneral \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + this.cnt_receive);
    }

    private JsonArray getTherChainGeneral() throws Throwable {
        this.updTherChainGeneral = this.getUpdCount("updTherChainGeneral");
        return SafeJO.valueOf((JsonObject)OLM101.SQL.executeRDB("olm101_ther_chain_1_v1", Json.createObjectBuilder().add("upd_count", this.updTherChainGeneral).add("customer_id", OLM101.config.getCustomerId()))).getJsonArray("r1");
    }
}

