/*
 * Decompiled with CFR 0.152.
 */
package ru.farmbazis.oporalocal.olm101.synchro;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.EnumSet;
import ru.farmbazis.oporalocal.ISQL;
import ru.farmbazis.oporalocal.olm101.OLM101;
import ru.farmbazis.oporalocal.olm101.config.Param;
import ru.farmbazis.oporalocal.olm101.synchro.SynchroBase;
import ru.farmbazis.oporalocal.util.SafeJO;

public class TovarEdIzm
extends SynchroBase {
    public static final String FASOVKA_IN_BRANCH = "FasovkaInBranch";
    public static final String FASOVKA_DELETED = "FasovkaDeleted";
    private String FasovkaDeleted;
    private long updTovarEdIzm = 0L;

    @Override
    public void deleteOldData() throws Throwable {
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ...");
        OLM101.SQL.executeLocal("olm101_tovar_ed_izm_1_v1");
        this.setKFSParam(FASOVKA_DELETED, "1");
        this.writeLog("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u041e\u043a.");
    }

    @Override
    protected void doWork() throws Throwable {
        this.FasovkaDeleted = "0";
        SafeJO localData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_tovar_ed_izm_2_v1"));
        this.cnt_send = localData.getJsonArraySize("r1");
        this.printCounter("", EnumSet.of(SynchroBase.Counter.SEND));
        this.setSrvTovarEdIzmId(this.getSrvData(this.readTovarEdIzm(localData.getJsonArray("r1"))));
    }

    private JsonArray getSrvData(JsonArray localData) throws Throwable {
        SafeJO srvData;
        String serverFasovkaInBranch;
        String localFasovkaInBranch = this.getKFSParam(FASOVKA_IN_BRANCH);
        if (!localFasovkaInBranch.equalsIgnoreCase("0") && !localFasovkaInBranch.equalsIgnoreCase("1")) {
            localFasovkaInBranch = "N";
        }
        if (!(serverFasovkaInBranch = SafeJO.valueOf((JsonObject)(srvData = SafeJO.valueOf((JsonObject)OLM101.SQL.executeCDB("olm101_12_v1", ISQL.FuncType.READ_WRITE, Json.createObjectBuilder().add("customer_id", OLM101.config.getCustomerId()).add("branch_id", OLM101.config.getDefaultBranchId()).add("upd", this.updTovarEdIzm).add("fasovka_in_branch", localFasovkaInBranch).add("division", Param.getDivision().equalsIgnoreCase("" + OLM101.config.getDefaultBranchId()) || Param.getDivision().isEmpty() ? "" : Param.getDivision()).add("r1", (JsonValue)localData)))).getJsonArray("r1").getJsonObject(0)).getString(FASOVKA_IN_BRANCH)).equalsIgnoreCase("0") && !serverFasovkaInBranch.equalsIgnoreCase("1")) {
            serverFasovkaInBranch = "0";
        }
        if (!localFasovkaInBranch.equalsIgnoreCase(serverFasovkaInBranch)) {
            this.setKFSParam(FASOVKA_IN_BRANCH, serverFasovkaInBranch);
            this.deleteOldData();
            this.FasovkaDeleted = "1";
        }
        return srvData.getJsonArray("r2");
    }

    private void setSrvTovarEdIzmId(JsonArray ja) throws Throwable {
        this.resetCounter();
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            long upd = jo.getStringAsLong("updCount");
            if (this.updTovarEdIzm < upd) {
                this.updTovarEdIzm = upd;
            }
            array.add((JsonValue)Json.createObjectBuilder().add("regId", jo.getStringAsLong("regId")).add("sprEdIzmId", jo.getStringAsLong("sprEdIzmId")).add("ratio", jo.getStringAsInt("ratio")).add("tovarEdIzmId", jo.getStringAsLong("tovarEdIzmId")).add("update_backup", this.FasovkaDeleted.equalsIgnoreCase("1")).add("local_id", jo.getStringAsLong("local_id")).add("disable", jo.getString("disable").equalsIgnoreCase("1")).add("BranchID", jo.getStringAsLong("BranchID")).build());
        }
        JsonObject jo = Json.createObjectBuilder().add("r1", (JsonValue)array.build()).build();
        SafeJO response = SafeJO.valueOf((JsonObject)OLM101.SQL.executeLocal("olm101_tovar_ed_izm_3_v1", jo));
        this.cnt_insert = response.getInt("cnt_insert");
        this.cnt_update = response.getInt("cnt_update");
        this.printCounter("", EnumSet.of(SynchroBase.Counter.UPDATE, SynchroBase.Counter.INSERT));
    }

    private JsonArray readTovarEdIzm(JsonArray ja) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            SafeJO jo = SafeJO.valueOf((JsonObject)ja.getJsonObject(i));
            JsonObjectBuilder jBuild = Json.createObjectBuilder();
            jBuild.add("reg_id", jo.getLong("reg_id")).add("ratio", jo.getInt("ratio")).add("spr_ed_izm_id", jo.getLong("spr_ed_izm_id")).add("disable", jo.getBoolean("disable") ? "1" : "0").add("user_id", jo.getLong("user_id")).add("local_id", jo.getLong("local_id")).add("branch_id", jo.getLong("branch_id"));
            array.add((JsonValue)jBuild.build());
        }
        return array.build();
    }
}

