SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

CREATE OR REPLACE FUNCTION public.iif(condition boolean, true_result anyelement, false_result anyelement)
 RETURNS anyelement
 LANGUAGE sql
 IMMUTABLE
AS $function$
  SELECT CASE WHEN condition THEN true_result ELSE false_result END
$function$
;

CREATE TABLE IF NOT EXISTS public.config (
	"key" text NOT NULL,
	value text NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS config_ind_1 ON public.config USING btree (key) INCLUDE (value);

CREATE TABLE IF NOT EXISTS public.db_update_opora_web (
	db_update_opora_web_id int8 NOT NULL,
	update_text text NULL,
	date_create timestamptz(0) NULL,
	status int4 DEFAULT 0 NULL,
	upd_count int8 NULL,
	error text NULL, 
	CONSTRAINT db_update_opora_web_pkey PRIMARY KEY (db_update_opora_web_id)
);
COMMENT ON TABLE public.db_update_opora_web IS 'Обновление для локалькой базы Опора веб';

COMMENT ON COLUMN public.db_update_opora_web.db_update_opora_web_id IS 'Идентификатор.';
COMMENT ON COLUMN public.db_update_opora_web.update_text IS 'Текст обновления';
COMMENT ON COLUMN public.db_update_opora_web.date_create IS 'Время создания';
COMMENT ON COLUMN public.db_update_opora_web.status IS 'Статус обновления 0-Необработанные 1-Успешно 2-Ошибка';
COMMENT ON COLUMN public.db_update_opora_web.upd_count IS 'Счетчик';
COMMENT ON COLUMN public.db_update_opora_web.error IS 'текст ошибки';

CREATE OR REPLACE FUNCTION public.func_olm2_db_update_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
   max_upd_count bigint;
begin

	create temp table tmp_data(data jsonb) on commit drop;
 
	insert into tmp_data(data)
	select v.value
	from jsonb_array_elements(p_param->'r1') v;

	with cte_d as (
		select (t.data->>'db_update_opora_web_id')::bigint as db_update_opora_web_id
		from tmp_data t
		where (t.data->>'disable')::boolean
	)
	
	delete from public.db_update_opora_web d
	using cte_d t 
	where t.db_update_opora_web_id = d.db_update_opora_web_id;
 
 	with cte as (
		select 
	 		(t.data->>'db_update_opora_web_id')::bigint as db_update_opora_web_id,
	 		t.data->>'update_text' as update_text,
			(t.data->>'date_create')::timestamptz(0) as date_create,
			(t.data->>'upd_count')::bigint as upd_count
 		from tmp_data t
 		where not (t.data->>'disable')::boolean)
 
	insert into public.db_update_opora_web(
		db_update_opora_web_id,update_text,date_create,upd_count)
	select 
 		c.db_update_opora_web_id, c.update_text, c.date_create, c.upd_count
	from cte c
	on conflict (db_update_opora_web_id) do
	update set
		update_text = excluded.update_text,
		date_create = excluded.date_create,
		upd_count = excluded.upd_count;

	
	select max((t.data->>'upd_count')::bigint)
	from tmp_data t	
	into max_upd_count;

    perform func_spr_update_count_1_v1('db_update_opora_web', max_upd_count); 
	
	return '{}';

end
$function$
;

CREATE OR REPLACE FUNCTION public.func_olm2_db_update_3_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
   temp_row record;
   o_err text;
begin
	
	FOR temp_row IN
        select * from public.db_update_opora_web d where d.status = 0 order by d.db_update_opora_web_id
    loop
	    begin
        	execute replace(replace(temp_row.update_text,' :nnn',chr(10)),' :ttt',chr(9));
       		update public.db_update_opora_web d set status = 1 where d.db_update_opora_web_id = temp_row.db_update_opora_web_id;
       	exception when others
       	then
         	GET STACKED DIAGNOSTICS o_err = MESSAGE_TEXT; 
       		update public.db_update_opora_web d set status = 2, error = o_err where d.db_update_opora_web_id = temp_row.db_update_opora_web_id;
       	end;
    END LOOP;
   
	
	return '{}';

end
$function$
;

CREATE OR REPLACE FUNCTION public.func_ol_1_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
begin

	return jsonb_build_object(
		'newUser',iif(c.value = p_param->>'guid', false, true)
	)
	from config c
	where c.key = 'guid';

end
$function$
;

CREATE OR REPLACE FUNCTION public.func_ol_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
begin

	truncate table person;
	truncate table branch;
	truncate table config;
	truncate table division;
	
	insert into config(key, value)
	values('guid', p_param->>'guid');
	
	return '{}';
	
end
$function$
;

CREATE OR REPLACE FUNCTION public.func_ol_4_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
  l_branchId text;
  l_branch text;
begin

	select coalesce(c.value,'0'), coalesce(b.branch,'')
	into l_branchId, l_branch
	from config c
	left join branch b on b.branch_id = (c.value)::int
	where
		c.key = 'defaultBranch';    
    
    
	return jsonb_build_object(
		'branchId',  coalesce(l_branchId, '0'),
		'branch', coalesce(l_branch, '')		
	);
end
$function$
;

CREATE TABLE IF NOT EXISTS public.branch (
	branch_id int4 NOT NULL,
	branch text NULL,
	"disable" bool NULL,
	upd_count int8 NULL,
	CONSTRAINT branch_pkey PRIMARY KEY (branch_id)
);

CREATE OR REPLACE FUNCTION public.func_olm2_branch_3_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
   max_upd_count bigint;
begin

	create temp table tmp_data(data jsonb) on commit drop;
 
	insert into tmp_data(data)
	select v.value
	from jsonb_array_elements(p_param->'r1') v;
 
 	with cte as (
		select 
	 		(t.data->>'branch_id')::bigint as branch_id,
	 		t.data->>'branch' as branch,
			(t.data->>'disable')::boolean as disable,
			(t.data->>'upd_count')::bigint as upd_count
 		from tmp_data t)
 
	insert into branch(
		branch_id, branch, disable, upd_count)
	select 
 		c.branch_id, c.branch, c.disable, c.upd_count
	from cte c
	on conflict (branch_id) do
	update set
		branch = excluded.branch,
		disable = excluded.disable,
		upd_count = excluded.upd_count;

	
	select max((t.data->>'upd_count')::bigint)
	from tmp_data t	
	into max_upd_count;

    perform func_spr_update_count_1_v1('branch', max_upd_count); 
	
	return '{}';

end
$function$
;

CREATE TABLE IF NOT EXISTS public.division (
	division_id numeric(23,4) NOT NULL,
	parent_id int8 NULL, 
	child_id int8 NULL, 
	upd_count int8 NULL,
	div_number int2 NULL, 
	"disable" bool NULL, 
	is_for_mark bool NULL, 
	CONSTRAINT division_pkey PRIMARY KEY (division_id)
);
COMMENT ON TABLE public.division IS 'Список отделов';

COMMENT ON COLUMN public.division.division_id IS 'Идентификатор';
COMMENT ON COLUMN public.division.parent_id IS 'Главный отдел (ссылка на branch)';
COMMENT ON COLUMN public.division.child_id IS 'Подчиненный отдел (ссылка на branch)';
COMMENT ON COLUMN public.division.upd_count IS 'Счетчик';
COMMENT ON COLUMN public.division.div_number IS 'Номер отдела';
COMMENT ON COLUMN public.division."disable" IS 'Призрак активности';
COMMENT ON COLUMN public.division.is_for_mark IS 'Призрак отдела для маркировки';


CREATE OR REPLACE FUNCTION public.func_olm2_division_3_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
   max_upd_count bigint;
begin

	create temp table tmp_data(data jsonb) on commit drop;
 
	insert into tmp_data(data)
	select v.value
	from jsonb_array_elements(p_param->'r1') v;
 
 	with cte as (
		select 
	 		(t.data->>'division_id')::numeric(23,4) as division_id,
	 		(t.data->>'parent_id')::bigint as parent_id,
	 		(t.data->>'child_id')::bigint as child_id,
	 		(t.data->>'upd_count')::bigint as upd_count,
	 		(t.data->>'div_number')::int as div_number,
			(t.data->>'disable')::boolean as disable,
			(t.data->>'is_for_mark')::boolean as is_for_mark
 		from tmp_data t)
 
	insert into division(
		division_id, parent_id, child_id, upd_count, div_number, "disable", is_for_mark)
	select 
 		c.division_id, c.parent_id, c.child_id, c.upd_count, c.div_number, c.disable, c.is_for_mark
	from cte c
	on conflict (division_id) do
	update set
		parent_id = excluded.parent_id,
		child_id = excluded.child_id,
		disable = excluded.disable,
		div_number = excluded.div_number,
		is_for_mark = excluded.is_for_mark,
		upd_count = excluded.upd_count;
	
	select max((t.data->>'upd_count')::bigint)
	from tmp_data t	
	into max_upd_count;

    perform func_spr_update_count_1_v1('division', max_upd_count); 	
		
	return '{}';

end
$function$
;

create table if not exists public.customer_user (
    customer_user_id  bigint,
    disable           boolean,
    user_name         text,
    pass              text,
    inn               text,
    key_bonus_plus    text,
    constraint customer_user_pkey primary key (customer_user_id)
);

COMMENT ON TABLE public.customer_user IS 'Пользователи';

COMMENT ON COLUMN public.customer_user.customer_user_id IS 'Идентификатор';
COMMENT ON COLUMN public.customer_user.user_name IS 'Имя пользователя';
COMMENT ON COLUMN public.customer_user.pass IS 'Пароль';
COMMENT ON COLUMN public.customer_user.inn IS 'ИНН';
COMMENT ON COLUMN public.customer_user.key_bonus_plus IS 'уникальный код сотрудника для программы лояльности БонусПлюс';
COMMENT ON COLUMN public.customer_user.disable IS 'Признак активности';


create table if not exists public.customer_user_in_group (
    customer_user_id        bigint,
    customer_user_group_id  int,
    constraint customer_user_in_group_pkey primary key (customer_user_id,customer_user_group_id)
);

COMMENT ON TABLE public.customer_user_in_group IS 'Принадлежность пользователей к группам';

COMMENT ON COLUMN public.customer_user_in_group.customer_user_id IS 'Идентификатор пользователя';
COMMENT ON COLUMN public.customer_user_in_group.customer_user_group_id IS 'Идентификатор группы';


create table if not exists public.customer_user_in_branch (
    customer_user_id   bigint,
    branch_id          bigint,
    editable           boolean,
    constraint customer_user_in_branch_pkey primary key (customer_user_id,branch_id)
);

COMMENT ON TABLE public.customer_user_in_branch IS 'Принадлежность пользователей к филиалам';

COMMENT ON COLUMN public.customer_user_in_branch.customer_user_id IS 'Идентификатор пользователя';
COMMENT ON COLUMN public.customer_user_in_branch.branch_id IS 'Идентификатор филиала';
COMMENT ON COLUMN public.customer_user_in_branch.editable IS 'Право пользователя на редактирование';

CREATE TABLE IF NOT EXISTS public.spr_update_count (
	spr_name text NOT NULL,
	upd_count int8 NOT NULL DEFAULT 0
);

CREATE UNIQUE INDEX IF NOT EXISTS spr_update_count_ind_1 ON public.spr_update_count USING btree (spr_name) INCLUDE (upd_count);
COMMENT ON TABLE public.spr_update_count IS 'Счетчики обновления справочников';

COMMENT ON COLUMN public.spr_update_count.spr_name IS 'Справочник';
COMMENT ON COLUMN public.spr_update_count.upd_count IS 'Счетчик';

CREATE OR REPLACE FUNCTION public.func_olm2_customer_user_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare 
  r record;
  max_upd_count bigint = 0;
begin
	for r in (
	 	select (v.value->>'customeruserid')::bigint as customer_user_id,
	 	       (v.value->>'inn') as inn,
	 	       (v.value->>'keybonusplus') as key_bonus_plus,
	 	       (v.value->>'pass') as pass,
	 	       (v.value->>'username') as user_name,
	 	       (v.value->>'upd_count')::bigint as upd_count,
	 	       (v.value->>'disable')::boolean as disable
	    from jsonb_array_elements(p_param->'r1') v) loop
		    
		if (r.upd_count > max_upd_count) then
		    max_upd_count = r.upd_count;
		end if;	
	
	    if (not exists(select 1 from customer_user
                     where customer_user_id = r.customer_user_id)) then
                     
           insert into customer_user(customer_user_id, "disable", user_name, pass, inn, key_bonus_plus)  
           values (r.customer_user_id, r."disable", r.user_name, r.pass, r.inn, r.key_bonus_plus);
        else
          update customer_user
          set disable = r.disable,
              user_name = r.user_name,
              pass = r.pass,
              inn = r.inn,
              key_bonus_plus = r.key_bonus_plus
		  where customer_user_id = r.customer_user_id
		      and ((coalesce(user_name,'') != r.user_name) or
		       (coalesce(disable,false) != r.disable) or
		       (coalesce(pass,'') != r.pass) or
		       (coalesce(inn,'') != r.inn) or
		       (coalesce(key_bonus_plus,'') != r.key_bonus_plus));      
	    end if;	                         
	    
	end loop;

    perform func_spr_update_count_1_v1('customeruser', max_upd_count);	
	
	return '{}';   
end
$function$
;

COMMENT ON FUNCTION public.func_olm2_customer_user_2_v1(jsonb) IS 'Обновление справочника customer_user';

CREATE OR REPLACE FUNCTION public.func_olm2_user_in_branch_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare 
  r record;
  max_upd_count bigint = 0;
begin
	for r in (
	 	select (v.value->>'customeruserid')::bigint as customer_user_id,
	 	       (v.value->>'branchid')::bigint as branch_id,
	 	       (v.value->>'upd_count')::bigint as upd_count,
	 	       (v.value->>'disable')::boolean as disable,
	 	       (v.value->>'editable')::boolean as editable
	    from jsonb_array_elements(p_param->'r1') v) loop
		
		if (r.upd_count > max_upd_count) then
		    max_upd_count = r.upd_count;
		end if;	
		    
		if (r."disable" = true) then
		  delete from customer_user_in_branch
		  where customer_user_id = r.customer_user_id and branch_id = r.branch_id;
		else
		  if (not exists(select 1 from customer_user_in_branch
                         where customer_user_id = r.customer_user_id and branch_id = r.branch_id)) then
                         
             insert into customer_user_in_branch(customer_user_id, branch_id, editable)  
             values (r.customer_user_id, r.branch_id, r.editable);
                         
          else
             update customer_user_in_branch
             set editable = r.editable
		     where customer_user_id = r.customer_user_id and branch_id = r.branch_id;
		    
		  end if;	                         
		end if;		    
	end loop;

    perform func_spr_update_count_1_v1('customeruserinbranch', max_upd_count);	
	
	return '{}';   
end
$function$
;

COMMENT ON FUNCTION public.func_olm2_user_in_branch_2_v1(jsonb) IS 'Обновление справочника customer_user_in_branch';

CREATE OR REPLACE FUNCTION public.func_olm2_user_in_group_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare 
  r record;
  max_upd_count bigint = 0;
begin
	for r in (
	 	select (v.value->>'customeruserid')::bigint as customer_user_id,
	 	       (v.value->>'customerusergroupid')::bigint as customer_user_group_id,
	 	       (v.value->>'upd_count')::bigint as upd_count,
	 	       (v.value->>'disable')::boolean as disable
	    from jsonb_array_elements(p_param->'r1') v) loop
		    
		if (r.upd_count > max_upd_count) then
		    max_upd_count = r.upd_count;
		end if;	
		    
		if (r."disable" = true) then
		  delete from customer_user_in_group
		  where customer_user_id = r.customer_user_id and customer_user_group_id = r.customer_user_group_id;
		else
		  if (not exists(select 1 from customer_user_in_group
                         where customer_user_id = r.customer_user_id and customer_user_group_id = r.customer_user_group_id)) then
                         
             insert into customer_user_in_group(customer_user_id, customer_user_group_id)  
             values (r.customer_user_id, r.customer_user_group_id);
	    
		  end if;	                         
		end if;		    
	end loop;

    perform func_spr_update_count_1_v1('customeruseringroup', max_upd_count);	
	
	return '{}';   
end
$function$
;

COMMENT ON FUNCTION public.func_olm2_user_in_group_2_v1(jsonb) IS 'Обновление справочника customer_user_in_group';

CREATE OR REPLACE FUNCTION public.func_get_spr_upd_count_1_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
	declare
		p_upd_count bigint;
begin

	select upd_count 
	into p_upd_count
	from spr_update_count d
	where d.spr_name = (p_param->>'spr_name');
	
	return jsonb_build_object(
		'upd_count', coalesce(p_upd_count, 0)
	);

end
$function$
;

comment on function public.func_get_spr_upd_count_1_v1(jsonb) is 'Получение последнего upd_count';

CREATE OR REPLACE FUNCTION public.func_op_login_1_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
	l_users jsonb;
    l_branches jsonb;
	l_branch_id bigint;
    l_branch text;
begin
	
	select b.branch_id, b.branch
	into l_branch_id, l_branch	
	from config c
	join branch b on b.branch_id = (c.value)::bigint
	where c.key = 'defaultBranch';	
	 
	with cte as (
		select cu.customer_user_id, cu.user_name 
		from customer_user_in_branch cub
		join customer_user cu on cu.customer_user_id = cub.customer_user_id and  cu."disable" = false
		where cub.branch_id = l_branch_id and cub.editable		
		union all
		select prog.customer_user_id, prog.user_name 
		from customer_user prog 
		where prog.customer_user_id = 1)

	select jsonb_agg(
		jsonb_build_object(
			'id', customer_user_id,
			'name', user_name
		)
	)
	into l_users
	from cte;

	if (coalesce(l_branch_id, -1) <=0 ) then
		select jsonb_agg(
			jsonb_build_object(
				'branch_id', branch_id,
				'branch', branch
			)
		)
		into l_branches
		from branch b
		where b."disable" = false;
	end if;
	
	return jsonb_build_object(
		'branch_id', coalesce(l_branch_id, -1),
		'branch', coalesce(l_branch, ''),
		'r1', l_users,
		'r2', l_branches
	); 
end
$function$
;

comment on function public.func_op_login_1_v1(jsonb) is 'Список пользователей';

CREATE OR REPLACE FUNCTION public.func_op_login_2_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
	i_user_id bigint;
	i_password text;
begin
	i_user_id = (p_param->>'user')::bigint;
	i_password = (p_param->>'password');

	return
		jsonb_build_object(
			'userId', customer_user_id,
			'userName', cu.user_name,
			'inn', cu.inn,
			'authToken', gen_random_uuid()
		)
	from customer_user cu
	where cu.customer_user_id = i_user_id 
		and cu.pass = i_password and cu.disable = false;
end
$function$
;

comment on function public.func_op_login_2_v1(jsonb) is 'авторизация';

CREATE OR REPLACE FUNCTION public.func_op_login_3_v1(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
begin
  truncate table customer_user_in_branch;
  truncate table customer_user_in_group;
  truncate table customer_user;
  update spr_update_count
	set	upd_count = 0
	where spr_name in ('customeruser','customeruseringroup','customeruserinbranch');

  return '{}';
end
$function$
;

comment on function public.func_op_login_3_v1(jsonb) is 'очистка таблиц пользователя при установке филиала по умолчанию';

CREATE OR REPLACE FUNCTION public.func_set_config(p_param jsonb)
 RETURNS jsonb
 LANGUAGE plpgsql
AS $function$
declare
  i_key text;
  i_value text;
begin
	
  i_key = p_param->>'key';
  i_value = p_param->>'value';
  	
  if (not exists (select 1 from config where key = i_key)) then
  	insert into config(key, value)
  	values (i_key, i_value);
  else
	update config set
		value = i_value
	where key = i_key;
  end if;

  return '{}';
end
$function$
;

CREATE OR REPLACE FUNCTION public.func_spr_update_count_1_v1(i_spr_name text, i_upd_count bigint)
 RETURNS void
 LANGUAGE plpgsql
AS $function$
begin
  if (not exists (select 1 from spr_update_count where spr_name = i_spr_name)) then
  	insert into spr_update_count(spr_name, upd_count)
  	values (i_spr_name, i_upd_count);
  else
	update spr_update_count
	set	upd_count = i_upd_count
	where spr_name = i_spr_name;
  end if;
end
$function$
;

comment on function public.func_spr_update_count_1_v1(text, bigint) is 'Обновление значения счетчика upd_count';
