#!/usr/bin/env bash
current_dir=`pwd`
app_dir='/opt/osnova'
echo "Устанавливаем docker"
sudo apt update && sudo apt install -y curl
curl -fsSL https://get.docker.com -o /tmp/get-docker.sh
sudo sh /tmp/get-docker.sh
rm /tmp/get-docker.sh
if [ -d "$app_dir" ]; then
	echo "Папка $app_dir существует, удаляем содержимое"
	cd $app_dir
	sudo docker compose down
	sudo docker system prune -a --force
	sudo rm -rf $app_dir
fi
echo "Устанавливаем ОСНОВА"
sudo mkdir $app_dir
sudo cp -R $current_dir/* $app_dir
cd $app_dir
echo "Запускаем ОСНОВА"
sudo docker compose up -d --build --force-recreate
echo "Создаём ярлык на рабочем столе"
cat > ~/Desktop/ОСНОВА.desktop << EOF
[Desktop Entry]
Name=Запуск ОСНОВА
Exec=xdg-open http://localhost:8080/OporaLocal/
Type=Application
Icon=web-browser
EOF
